"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeExtPrivate = exports.readExtPrivate = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const ot_ext_private_1 = require("@ot-builder/ot-ext-private");
const xprv_1 = require("../xprv");
function readExtPrivate(sfnt, cfg, gOrd, md) {
    const result = {};
    if (cfg.extPrivate.processExtPrivateTable) {
        const bXPrv = sfnt.tables.get(ot_ext_private_1.XPrv.Tag);
        if (bXPrv)
            result.xPrv = new bin_util_1.BinaryView(bXPrv).next(xprv_1.ReadXPrv, gOrd);
    }
    return result;
}
exports.readExtPrivate = readExtPrivate;
function writeExtPrivate(out, cfg, OtExtPrivate, gOrd, md) {
    if (cfg.extPrivate.processExtPrivateTable && OtExtPrivate.xPrv) {
        out.add(ot_ext_private_1.XPrv.Tag, bin_util_1.Frag.packFrom(xprv_1.WriteXPrv, OtExtPrivate.xPrv, gOrd));
    }
}
exports.writeExtPrivate = writeExtPrivate;
//# sourceMappingURL=index.js.map