// Copyright 2024 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Tests for firestore clients.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.3
// source: tests.proto

package conformance

import (
	reflect "reflect"
	sync "sync"

	firestorepb "cloud.google.com/go/firestore/apiv1/firestorepb"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DocChange_Kind int32

const (
	DocChange_KIND_UNSPECIFIED DocChange_Kind = 0
	DocChange_ADDED            DocChange_Kind = 1
	DocChange_REMOVED          DocChange_Kind = 2
	DocChange_MODIFIED         DocChange_Kind = 3
)

// Enum value maps for DocChange_Kind.
var (
	DocChange_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "ADDED",
		2: "REMOVED",
		3: "MODIFIED",
	}
	DocChange_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"ADDED":            1,
		"REMOVED":          2,
		"MODIFIED":         3,
	}
)

func (x DocChange_Kind) Enum() *DocChange_Kind {
	p := new(DocChange_Kind)
	*p = x
	return p
}

func (x DocChange_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DocChange_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_tests_proto_enumTypes[0].Descriptor()
}

func (DocChange_Kind) Type() protoreflect.EnumType {
	return &file_tests_proto_enumTypes[0]
}

func (x DocChange_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DocChange_Kind.Descriptor instead.
func (DocChange_Kind) EnumDescriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{19, 0}
}

// A collection of tests.
type TestFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Tests []*Test `protobuf:"bytes,1,rep,name=tests,proto3" json:"tests,omitempty"`
}

func (x *TestFile) Reset() {
	*x = TestFile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestFile) ProtoMessage() {}

func (x *TestFile) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestFile.ProtoReflect.Descriptor instead.
func (*TestFile) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{0}
}

func (x *TestFile) GetTests() []*Test {
	if x != nil {
		return x.Tests
	}
	return nil
}

// A Test describes a single client method call and its expected result.
type Test struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"` // short description of the test
	Comment     string `protobuf:"bytes,10,opt,name=comment,proto3" json:"comment,omitempty"`        // a comment describing the behavior being tested
	// Types that are assignable to Test:
	//
	//	*Test_Get
	//	*Test_Create
	//	*Test_Set
	//	*Test_Update
	//	*Test_UpdatePaths
	//	*Test_Delete
	//	*Test_Query
	//	*Test_Listen
	Test isTest_Test `protobuf_oneof:"test"`
}

func (x *Test) Reset() {
	*x = Test{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Test) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Test) ProtoMessage() {}

func (x *Test) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Test.ProtoReflect.Descriptor instead.
func (*Test) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{1}
}

func (x *Test) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Test) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (m *Test) GetTest() isTest_Test {
	if m != nil {
		return m.Test
	}
	return nil
}

func (x *Test) GetGet() *GetTest {
	if x, ok := x.GetTest().(*Test_Get); ok {
		return x.Get
	}
	return nil
}

func (x *Test) GetCreate() *CreateTest {
	if x, ok := x.GetTest().(*Test_Create); ok {
		return x.Create
	}
	return nil
}

func (x *Test) GetSet() *SetTest {
	if x, ok := x.GetTest().(*Test_Set); ok {
		return x.Set
	}
	return nil
}

func (x *Test) GetUpdate() *UpdateTest {
	if x, ok := x.GetTest().(*Test_Update); ok {
		return x.Update
	}
	return nil
}

func (x *Test) GetUpdatePaths() *UpdatePathsTest {
	if x, ok := x.GetTest().(*Test_UpdatePaths); ok {
		return x.UpdatePaths
	}
	return nil
}

func (x *Test) GetDelete() *DeleteTest {
	if x, ok := x.GetTest().(*Test_Delete); ok {
		return x.Delete
	}
	return nil
}

func (x *Test) GetQuery() *QueryTest {
	if x, ok := x.GetTest().(*Test_Query); ok {
		return x.Query
	}
	return nil
}

func (x *Test) GetListen() *ListenTest {
	if x, ok := x.GetTest().(*Test_Listen); ok {
		return x.Listen
	}
	return nil
}

type isTest_Test interface {
	isTest_Test()
}

type Test_Get struct {
	Get *GetTest `protobuf:"bytes,2,opt,name=get,proto3,oneof"`
}

type Test_Create struct {
	Create *CreateTest `protobuf:"bytes,3,opt,name=create,proto3,oneof"`
}

type Test_Set struct {
	Set *SetTest `protobuf:"bytes,4,opt,name=set,proto3,oneof"`
}

type Test_Update struct {
	Update *UpdateTest `protobuf:"bytes,5,opt,name=update,proto3,oneof"`
}

type Test_UpdatePaths struct {
	UpdatePaths *UpdatePathsTest `protobuf:"bytes,6,opt,name=update_paths,json=updatePaths,proto3,oneof"`
}

type Test_Delete struct {
	Delete *DeleteTest `protobuf:"bytes,7,opt,name=delete,proto3,oneof"`
}

type Test_Query struct {
	Query *QueryTest `protobuf:"bytes,8,opt,name=query,proto3,oneof"`
}

type Test_Listen struct {
	Listen *ListenTest `protobuf:"bytes,9,opt,name=listen,proto3,oneof"`
}

func (*Test_Get) isTest_Test() {}

func (*Test_Create) isTest_Test() {}

func (*Test_Set) isTest_Test() {}

func (*Test_Update) isTest_Test() {}

func (*Test_UpdatePaths) isTest_Test() {}

func (*Test_Delete) isTest_Test() {}

func (*Test_Query) isTest_Test() {}

func (*Test_Listen) isTest_Test() {}

// Call to the DocumentRef.Get method.
type GetTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of the doc, e.g. "projects/projectID/databases/(default)/documents/C/d"
	DocRefPath string `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	// The request that the call should send to the Firestore service.
	Request *firestorepb.GetDocumentRequest `protobuf:"bytes,2,opt,name=request,proto3" json:"request,omitempty"`
}

func (x *GetTest) Reset() {
	*x = GetTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTest) ProtoMessage() {}

func (x *GetTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTest.ProtoReflect.Descriptor instead.
func (*GetTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{2}
}

func (x *GetTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *GetTest) GetRequest() *firestorepb.GetDocumentRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

// Call to DocumentRef.Create.
type CreateTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path of the doc, e.g. "projects/projectID/databases/(default)/documents/C/d"
	DocRefPath string `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"`
	// The data passed to Create, as JSON. The strings "Delete" and "ServerTimestamp"
	// denote the two special sentinel values. Values that could be interpreted as integers
	// (i.e. digit strings) should be treated as integers.
	JsonData string `protobuf:"bytes,2,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
	// The request that the call should generate.
	Request *firestorepb.CommitRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// If true, the call should result in an error without generating a request.
	// If this is true, request should not be set.
	IsError bool `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
}

func (x *CreateTest) Reset() {
	*x = CreateTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTest) ProtoMessage() {}

func (x *CreateTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTest.ProtoReflect.Descriptor instead.
func (*CreateTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{3}
}

func (x *CreateTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *CreateTest) GetJsonData() string {
	if x != nil {
		return x.JsonData
	}
	return ""
}

func (x *CreateTest) GetRequest() *firestorepb.CommitRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *CreateTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

// A call to DocumentRef.Set.
type SetTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DocRefPath string                     `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"` // path of doc
	Option     *SetOption                 `protobuf:"bytes,2,opt,name=option,proto3" json:"option,omitempty"`                             // option to the Set call, if any
	JsonData   string                     `protobuf:"bytes,3,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`         // data (see CreateTest.json_data)
	Request    *firestorepb.CommitRequest `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`                           // expected request
	IsError    bool                       `protobuf:"varint,5,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`           // call signals an error
}

func (x *SetTest) Reset() {
	*x = SetTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTest) ProtoMessage() {}

func (x *SetTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTest.ProtoReflect.Descriptor instead.
func (*SetTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{4}
}

func (x *SetTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *SetTest) GetOption() *SetOption {
	if x != nil {
		return x.Option
	}
	return nil
}

func (x *SetTest) GetJsonData() string {
	if x != nil {
		return x.JsonData
	}
	return ""
}

func (x *SetTest) GetRequest() *firestorepb.CommitRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *SetTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

// A call to the form of DocumentRef.Update that represents the data as a map
// or dictionary.
type UpdateTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DocRefPath   string                     `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"` // path of doc
	Precondition *firestorepb.Precondition  `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`                 // precondition in call, if any
	JsonData     string                     `protobuf:"bytes,3,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`         // data (see CreateTest.json_data)
	Request      *firestorepb.CommitRequest `protobuf:"bytes,4,opt,name=request,proto3" json:"request,omitempty"`                           // expected request
	IsError      bool                       `protobuf:"varint,5,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`           // call signals an error
}

func (x *UpdateTest) Reset() {
	*x = UpdateTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTest) ProtoMessage() {}

func (x *UpdateTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTest.ProtoReflect.Descriptor instead.
func (*UpdateTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *UpdateTest) GetPrecondition() *firestorepb.Precondition {
	if x != nil {
		return x.Precondition
	}
	return nil
}

func (x *UpdateTest) GetJsonData() string {
	if x != nil {
		return x.JsonData
	}
	return ""
}

func (x *UpdateTest) GetRequest() *firestorepb.CommitRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *UpdateTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

// A call to the form of DocumentRef.Update that represents the data as a list
// of field paths and their values.
type UpdatePathsTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DocRefPath   string                    `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"` // path of doc
	Precondition *firestorepb.Precondition `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`                 // precondition in call, if any
	// parallel sequences: field_paths[i] corresponds to json_values[i]
	FieldPaths []*FieldPath               `protobuf:"bytes,3,rep,name=field_paths,json=fieldPaths,proto3" json:"field_paths,omitempty"` // the argument field paths
	JsonValues []string                   `protobuf:"bytes,4,rep,name=json_values,json=jsonValues,proto3" json:"json_values,omitempty"` // the argument values, as JSON
	Request    *firestorepb.CommitRequest `protobuf:"bytes,5,opt,name=request,proto3" json:"request,omitempty"`                         // expected rquest
	IsError    bool                       `protobuf:"varint,6,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`         // call signals an error
}

func (x *UpdatePathsTest) Reset() {
	*x = UpdatePathsTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdatePathsTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePathsTest) ProtoMessage() {}

func (x *UpdatePathsTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePathsTest.ProtoReflect.Descriptor instead.
func (*UpdatePathsTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{6}
}

func (x *UpdatePathsTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *UpdatePathsTest) GetPrecondition() *firestorepb.Precondition {
	if x != nil {
		return x.Precondition
	}
	return nil
}

func (x *UpdatePathsTest) GetFieldPaths() []*FieldPath {
	if x != nil {
		return x.FieldPaths
	}
	return nil
}

func (x *UpdatePathsTest) GetJsonValues() []string {
	if x != nil {
		return x.JsonValues
	}
	return nil
}

func (x *UpdatePathsTest) GetRequest() *firestorepb.CommitRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *UpdatePathsTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

// A call to DocmentRef.Delete
type DeleteTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	DocRefPath   string                     `protobuf:"bytes,1,opt,name=doc_ref_path,json=docRefPath,proto3" json:"doc_ref_path,omitempty"` // path of doc
	Precondition *firestorepb.Precondition  `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition,omitempty"`
	Request      *firestorepb.CommitRequest `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`                 // expected rquest
	IsError      bool                       `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"` // call signals an error
}

func (x *DeleteTest) Reset() {
	*x = DeleteTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTest) ProtoMessage() {}

func (x *DeleteTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTest.ProtoReflect.Descriptor instead.
func (*DeleteTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteTest) GetDocRefPath() string {
	if x != nil {
		return x.DocRefPath
	}
	return ""
}

func (x *DeleteTest) GetPrecondition() *firestorepb.Precondition {
	if x != nil {
		return x.Precondition
	}
	return nil
}

func (x *DeleteTest) GetRequest() *firestorepb.CommitRequest {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *DeleteTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

// An option to the DocumentRef.Set call.
type SetOption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	All    bool         `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`      // if true, merge all fields ("fields" is ignored).
	Fields []*FieldPath `protobuf:"bytes,2,rep,name=fields,proto3" json:"fields,omitempty"` // field paths for a Merge option
}

func (x *SetOption) Reset() {
	*x = SetOption{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetOption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetOption) ProtoMessage() {}

func (x *SetOption) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetOption.ProtoReflect.Descriptor instead.
func (*SetOption) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{8}
}

func (x *SetOption) GetAll() bool {
	if x != nil {
		return x.All
	}
	return false
}

func (x *SetOption) GetFields() []*FieldPath {
	if x != nil {
		return x.Fields
	}
	return nil
}

type QueryTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	CollPath string                       `protobuf:"bytes,1,opt,name=coll_path,json=collPath,proto3" json:"coll_path,omitempty"` // path of collection, e.g. "projects/projectID/databases/(default)/documents/C"
	Clauses  []*Clause                    `protobuf:"bytes,2,rep,name=clauses,proto3" json:"clauses,omitempty"`
	Query    *firestorepb.StructuredQuery `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	IsError  bool                         `protobuf:"varint,4,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
}

func (x *QueryTest) Reset() {
	*x = QueryTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryTest) ProtoMessage() {}

func (x *QueryTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryTest.ProtoReflect.Descriptor instead.
func (*QueryTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{9}
}

func (x *QueryTest) GetCollPath() string {
	if x != nil {
		return x.CollPath
	}
	return ""
}

func (x *QueryTest) GetClauses() []*Clause {
	if x != nil {
		return x.Clauses
	}
	return nil
}

func (x *QueryTest) GetQuery() *firestorepb.StructuredQuery {
	if x != nil {
		return x.Query
	}
	return nil
}

func (x *QueryTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

type Clause struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Clause:
	//
	//	*Clause_Select
	//	*Clause_Where
	//	*Clause_OrderBy
	//	*Clause_Offset
	//	*Clause_Limit
	//	*Clause_StartAt
	//	*Clause_StartAfter
	//	*Clause_EndAt
	//	*Clause_EndBefore
	Clause isClause_Clause `protobuf_oneof:"clause"`
}

func (x *Clause) Reset() {
	*x = Clause{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Clause) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Clause) ProtoMessage() {}

func (x *Clause) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Clause.ProtoReflect.Descriptor instead.
func (*Clause) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{10}
}

func (m *Clause) GetClause() isClause_Clause {
	if m != nil {
		return m.Clause
	}
	return nil
}

func (x *Clause) GetSelect() *Select {
	if x, ok := x.GetClause().(*Clause_Select); ok {
		return x.Select
	}
	return nil
}

func (x *Clause) GetWhere() *Where {
	if x, ok := x.GetClause().(*Clause_Where); ok {
		return x.Where
	}
	return nil
}

func (x *Clause) GetOrderBy() *OrderBy {
	if x, ok := x.GetClause().(*Clause_OrderBy); ok {
		return x.OrderBy
	}
	return nil
}

func (x *Clause) GetOffset() int32 {
	if x, ok := x.GetClause().(*Clause_Offset); ok {
		return x.Offset
	}
	return 0
}

func (x *Clause) GetLimit() int32 {
	if x, ok := x.GetClause().(*Clause_Limit); ok {
		return x.Limit
	}
	return 0
}

func (x *Clause) GetStartAt() *Cursor {
	if x, ok := x.GetClause().(*Clause_StartAt); ok {
		return x.StartAt
	}
	return nil
}

func (x *Clause) GetStartAfter() *Cursor {
	if x, ok := x.GetClause().(*Clause_StartAfter); ok {
		return x.StartAfter
	}
	return nil
}

func (x *Clause) GetEndAt() *Cursor {
	if x, ok := x.GetClause().(*Clause_EndAt); ok {
		return x.EndAt
	}
	return nil
}

func (x *Clause) GetEndBefore() *Cursor {
	if x, ok := x.GetClause().(*Clause_EndBefore); ok {
		return x.EndBefore
	}
	return nil
}

type isClause_Clause interface {
	isClause_Clause()
}

type Clause_Select struct {
	Select *Select `protobuf:"bytes,1,opt,name=select,proto3,oneof"`
}

type Clause_Where struct {
	Where *Where `protobuf:"bytes,2,opt,name=where,proto3,oneof"`
}

type Clause_OrderBy struct {
	OrderBy *OrderBy `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3,oneof"`
}

type Clause_Offset struct {
	Offset int32 `protobuf:"varint,4,opt,name=offset,proto3,oneof"`
}

type Clause_Limit struct {
	Limit int32 `protobuf:"varint,5,opt,name=limit,proto3,oneof"`
}

type Clause_StartAt struct {
	StartAt *Cursor `protobuf:"bytes,6,opt,name=start_at,json=startAt,proto3,oneof"`
}

type Clause_StartAfter struct {
	StartAfter *Cursor `protobuf:"bytes,7,opt,name=start_after,json=startAfter,proto3,oneof"`
}

type Clause_EndAt struct {
	EndAt *Cursor `protobuf:"bytes,8,opt,name=end_at,json=endAt,proto3,oneof"`
}

type Clause_EndBefore struct {
	EndBefore *Cursor `protobuf:"bytes,9,opt,name=end_before,json=endBefore,proto3,oneof"`
}

func (*Clause_Select) isClause_Clause() {}

func (*Clause_Where) isClause_Clause() {}

func (*Clause_OrderBy) isClause_Clause() {}

func (*Clause_Offset) isClause_Clause() {}

func (*Clause_Limit) isClause_Clause() {}

func (*Clause_StartAt) isClause_Clause() {}

func (*Clause_StartAfter) isClause_Clause() {}

func (*Clause_EndAt) isClause_Clause() {}

func (*Clause_EndBefore) isClause_Clause() {}

type Select struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fields []*FieldPath `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *Select) Reset() {
	*x = Select{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Select) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Select) ProtoMessage() {}

func (x *Select) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Select.ProtoReflect.Descriptor instead.
func (*Select) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{11}
}

func (x *Select) GetFields() []*FieldPath {
	if x != nil {
		return x.Fields
	}
	return nil
}

type Where struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path      *FieldPath `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Op        string     `protobuf:"bytes,2,opt,name=op,proto3" json:"op,omitempty"`
	JsonValue string     `protobuf:"bytes,3,opt,name=json_value,json=jsonValue,proto3" json:"json_value,omitempty"`
}

func (x *Where) Reset() {
	*x = Where{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Where) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Where) ProtoMessage() {}

func (x *Where) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Where.ProtoReflect.Descriptor instead.
func (*Where) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{12}
}

func (x *Where) GetPath() *FieldPath {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Where) GetOp() string {
	if x != nil {
		return x.Op
	}
	return ""
}

func (x *Where) GetJsonValue() string {
	if x != nil {
		return x.JsonValue
	}
	return ""
}

type OrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path      *FieldPath `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Direction string     `protobuf:"bytes,2,opt,name=direction,proto3" json:"direction,omitempty"` // "asc" or "desc"
}

func (x *OrderBy) Reset() {
	*x = OrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OrderBy) ProtoMessage() {}

func (x *OrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OrderBy.ProtoReflect.Descriptor instead.
func (*OrderBy) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{13}
}

func (x *OrderBy) GetPath() *FieldPath {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *OrderBy) GetDirection() string {
	if x != nil {
		return x.Direction
	}
	return ""
}

type Cursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// one of:
	DocSnapshot *DocSnapshot `protobuf:"bytes,1,opt,name=doc_snapshot,json=docSnapshot,proto3" json:"doc_snapshot,omitempty"`
	JsonValues  []string     `protobuf:"bytes,2,rep,name=json_values,json=jsonValues,proto3" json:"json_values,omitempty"`
}

func (x *Cursor) Reset() {
	*x = Cursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cursor) ProtoMessage() {}

func (x *Cursor) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cursor.ProtoReflect.Descriptor instead.
func (*Cursor) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{14}
}

func (x *Cursor) GetDocSnapshot() *DocSnapshot {
	if x != nil {
		return x.DocSnapshot
	}
	return nil
}

func (x *Cursor) GetJsonValues() []string {
	if x != nil {
		return x.JsonValues
	}
	return nil
}

type DocSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Path     string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	JsonData string `protobuf:"bytes,2,opt,name=json_data,json=jsonData,proto3" json:"json_data,omitempty"`
}

func (x *DocSnapshot) Reset() {
	*x = DocSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocSnapshot) ProtoMessage() {}

func (x *DocSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocSnapshot.ProtoReflect.Descriptor instead.
func (*DocSnapshot) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{15}
}

func (x *DocSnapshot) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *DocSnapshot) GetJsonData() string {
	if x != nil {
		return x.JsonData
	}
	return ""
}

type FieldPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Field []string `protobuf:"bytes,1,rep,name=field,proto3" json:"field,omitempty"`
}

func (x *FieldPath) Reset() {
	*x = FieldPath{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FieldPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldPath) ProtoMessage() {}

func (x *FieldPath) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldPath.ProtoReflect.Descriptor instead.
func (*FieldPath) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{16}
}

func (x *FieldPath) GetField() []string {
	if x != nil {
		return x.Field
	}
	return nil
}

// A test of the Listen streaming RPC (a.k.a. FireStore watch).
// If the sequence of responses is provided to the implementation,
// it should produce the sequence of snapshots.
// If is_error is true, an error should occur after the snapshots.
//
// The tests assume that the query is
// Collection("projects/projectID/databases/(default)/documents/C").OrderBy("a", Ascending)
//
// The watch target ID used in these tests is 1. Test interpreters
// should either change their client's ID for testing,
// or change the ID in the tests before running them.
type ListenTest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Responses []*firestorepb.ListenResponse `protobuf:"bytes,1,rep,name=responses,proto3" json:"responses,omitempty"`
	Snapshots []*Snapshot                   `protobuf:"bytes,2,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	IsError   bool                          `protobuf:"varint,3,opt,name=is_error,json=isError,proto3" json:"is_error,omitempty"`
}

func (x *ListenTest) Reset() {
	*x = ListenTest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListenTest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListenTest) ProtoMessage() {}

func (x *ListenTest) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListenTest.ProtoReflect.Descriptor instead.
func (*ListenTest) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{17}
}

func (x *ListenTest) GetResponses() []*firestorepb.ListenResponse {
	if x != nil {
		return x.Responses
	}
	return nil
}

func (x *ListenTest) GetSnapshots() []*Snapshot {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *ListenTest) GetIsError() bool {
	if x != nil {
		return x.IsError
	}
	return false
}

type Snapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Docs     []*firestorepb.Document `protobuf:"bytes,1,rep,name=docs,proto3" json:"docs,omitempty"`
	Changes  []*DocChange            `protobuf:"bytes,2,rep,name=changes,proto3" json:"changes,omitempty"`
	ReadTime *timestamppb.Timestamp  `protobuf:"bytes,3,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
}

func (x *Snapshot) Reset() {
	*x = Snapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Snapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snapshot) ProtoMessage() {}

func (x *Snapshot) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snapshot.ProtoReflect.Descriptor instead.
func (*Snapshot) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{18}
}

func (x *Snapshot) GetDocs() []*firestorepb.Document {
	if x != nil {
		return x.Docs
	}
	return nil
}

func (x *Snapshot) GetChanges() []*DocChange {
	if x != nil {
		return x.Changes
	}
	return nil
}

func (x *Snapshot) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

type DocChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind     DocChange_Kind        `protobuf:"varint,1,opt,name=kind,proto3,enum=google.cloud.conformance.firestore.v1.DocChange_Kind" json:"kind,omitempty"`
	Doc      *firestorepb.Document `protobuf:"bytes,2,opt,name=doc,proto3" json:"doc,omitempty"`
	OldIndex int32                 `protobuf:"varint,3,opt,name=old_index,json=oldIndex,proto3" json:"old_index,omitempty"`
	NewIndex int32                 `protobuf:"varint,4,opt,name=new_index,json=newIndex,proto3" json:"new_index,omitempty"`
}

func (x *DocChange) Reset() {
	*x = DocChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_tests_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocChange) ProtoMessage() {}

func (x *DocChange) ProtoReflect() protoreflect.Message {
	mi := &file_tests_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocChange.ProtoReflect.Descriptor instead.
func (*DocChange) Descriptor() ([]byte, []int) {
	return file_tests_proto_rawDescGZIP(), []int{19}
}

func (x *DocChange) GetKind() DocChange_Kind {
	if x != nil {
		return x.Kind
	}
	return DocChange_KIND_UNSPECIFIED
}

func (x *DocChange) GetDoc() *firestorepb.Document {
	if x != nil {
		return x.Doc
	}
	return nil
}

func (x *DocChange) GetOldIndex() int32 {
	if x != nil {
		return x.OldIndex
	}
	return 0
}

func (x *DocChange) GetNewIndex() int32 {
	if x != nil {
		return x.NewIndex
	}
	return 0
}

var File_tests_proto protoreflect.FileDescriptor

var file_tests_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x4d, 0x0a, 0x08, 0x54, 0x65, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x41, 0x0a,
	0x05, 0x74, 0x65, 0x73, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x52, 0x05, 0x74, 0x65, 0x73, 0x74, 0x73,
	0x22, 0xad, 0x05, 0x0a, 0x04, 0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42, 0x0a, 0x03, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x03, 0x67, 0x65, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x06,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x03, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x54,
	0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x03, 0x73, 0x65, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52,
	0x06, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x5b, 0x0a, 0x0c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x74, 0x68,
	0x73, 0x54, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x12, 0x48, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x54, 0x65,
	0x73, 0x74, 0x48, 0x00, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4b, 0x0a, 0x06, 0x6c,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x54, 0x65, 0x73, 0x74, 0x48, 0x00,
	0x52, 0x06, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x65, 0x73, 0x74,
	0x22, 0x6e, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x64,
	0x6f, 0x63, 0x5f, 0x72, 0x65, 0x66, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x52, 0x65, 0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x41, 0x0a,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x22, 0xa4, 0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x12,
	0x20, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x5f, 0x72, 0x65, 0x66, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x52, 0x65, 0x66, 0x50, 0x61, 0x74,
	0x68, 0x12, 0x1b, 0x0a, 0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3c,
	0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08,
	0x69, 0x73, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07,
	0x69, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xeb, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x74, 0x54,
	0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x5f, 0x72, 0x65, 0x66, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x52, 0x65,
	0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x48, 0x0a, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x07,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73,
	0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73,
	0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xeb, 0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x5f, 0x72, 0x65, 0x66, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x52,
	0x65, 0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a,
	0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x12, 0x3c, 0x0a, 0x07, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x22, 0xc7, 0x02, 0x0a, 0x0f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61,
	0x74, 0x68, 0x73, 0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x5f, 0x72,
	0x65, 0x66, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x6f, 0x63, 0x52, 0x65, 0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x45, 0x0a, 0x0c, 0x70, 0x72, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x51, 0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61,
	0x74, 0x68, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x12, 0x3c, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xce, 0x01,
	0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x12, 0x20, 0x0a, 0x0c,
	0x64, 0x6f, 0x63, 0x5f, 0x72, 0x65, 0x66, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x64, 0x6f, 0x63, 0x52, 0x65, 0x66, 0x50, 0x61, 0x74, 0x68, 0x12, 0x45,
	0x0a, 0x0c, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x67,
	0x0a, 0x09, 0x53, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x61,
	0x6c, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x6c, 0x6c, 0x12, 0x48, 0x0a,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x52,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0xc8, 0x01, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6f, 0x6c, 0x6c, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x75,
	0x73, 0x65, 0x52, 0x07, 0x63, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x05, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x22, 0xd6, 0x04, 0x0a, 0x06, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x12, 0x47, 0x0a,
	0x06, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x48, 0x00, 0x52, 0x06,
	0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x77, 0x68, 0x65, 0x72, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x57, 0x68,
	0x65, 0x72, 0x65, 0x48, 0x00, 0x52, 0x05, 0x77, 0x68, 0x65, 0x72, 0x65, 0x12, 0x4b, 0x0a, 0x08,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x48, 0x00,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x18, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x4a, 0x0a, 0x08, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x41, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x46, 0x0a, 0x06, 0x65, 0x6e, 0x64,
	0x5f, 0x61, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6e, 0x64, 0x41,
	0x74, 0x12, 0x4e, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x72, 0x73, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x42, 0x65, 0x66, 0x6f, 0x72,
	0x65, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x22, 0x52, 0x0a, 0x06, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22,
	0x7c, 0x0a, 0x05, 0x57, 0x68, 0x65, 0x72, 0x65, 0x12, 0x44, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x0e,
	0x0a, 0x02, 0x6f, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x1d,
	0x0a, 0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x6d, 0x0a,
	0x07, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x44, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1c,
	0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x80, 0x01, 0x0a,
	0x06, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x55, 0x0a, 0x0c, 0x64, 0x6f, 0x63, 0x5f, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x52, 0x0b, 0x64, 0x6f, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x1f,
	0x0a, 0x0b, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0a, 0x6a, 0x73, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22,
	0x3e, 0x0a, 0x0b, 0x44, 0x6f, 0x63, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x12,
	0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x21, 0x0a, 0x09, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a, 0x05,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x54, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x66, 0x69,
	0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x22, 0xc2,
	0x01, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x31, 0x0a, 0x04, 0x64,
	0x6f, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x64, 0x6f, 0x63, 0x73, 0x12, 0x4a,
	0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x85, 0x02, 0x0a, 0x09, 0x44, 0x6f, 0x63, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x49, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x2f, 0x0a, 0x03,
	0x64, 0x6f, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x66, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x03, 0x64, 0x6f, 0x63, 0x12, 0x1b, 0x0a,
	0x09, 0x6f, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x6f, 0x6c, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x65,
	0x77, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6e,
	0x65, 0x77, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x42, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12,
	0x14, 0x0a, 0x10, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x44, 0x44, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x03, 0x42, 0xbf, 0x01, 0x0a, 0x29,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x66, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x54, 0x65, 0x73, 0x74, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66,
	0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0xaa, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x46, 0x69, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0xca, 0x02, 0x28, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x46, 0x69, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5c, 0x54, 0x65, 0x73, 0x74,
	0x73, 0x5c, 0x43, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_tests_proto_rawDescOnce sync.Once
	file_tests_proto_rawDescData = file_tests_proto_rawDesc
)

func file_tests_proto_rawDescGZIP() []byte {
	file_tests_proto_rawDescOnce.Do(func() {
		file_tests_proto_rawDescData = protoimpl.X.CompressGZIP(file_tests_proto_rawDescData)
	})
	return file_tests_proto_rawDescData
}

var file_tests_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_tests_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_tests_proto_goTypes = []interface{}{
	(DocChange_Kind)(0),                    // 0: google.cloud.conformance.firestore.v1.DocChange.Kind
	(*TestFile)(nil),                       // 1: google.cloud.conformance.firestore.v1.TestFile
	(*Test)(nil),                           // 2: google.cloud.conformance.firestore.v1.Test
	(*GetTest)(nil),                        // 3: google.cloud.conformance.firestore.v1.GetTest
	(*CreateTest)(nil),                     // 4: google.cloud.conformance.firestore.v1.CreateTest
	(*SetTest)(nil),                        // 5: google.cloud.conformance.firestore.v1.SetTest
	(*UpdateTest)(nil),                     // 6: google.cloud.conformance.firestore.v1.UpdateTest
	(*UpdatePathsTest)(nil),                // 7: google.cloud.conformance.firestore.v1.UpdatePathsTest
	(*DeleteTest)(nil),                     // 8: google.cloud.conformance.firestore.v1.DeleteTest
	(*SetOption)(nil),                      // 9: google.cloud.conformance.firestore.v1.SetOption
	(*QueryTest)(nil),                      // 10: google.cloud.conformance.firestore.v1.QueryTest
	(*Clause)(nil),                         // 11: google.cloud.conformance.firestore.v1.Clause
	(*Select)(nil),                         // 12: google.cloud.conformance.firestore.v1.Select
	(*Where)(nil),                          // 13: google.cloud.conformance.firestore.v1.Where
	(*OrderBy)(nil),                        // 14: google.cloud.conformance.firestore.v1.OrderBy
	(*Cursor)(nil),                         // 15: google.cloud.conformance.firestore.v1.Cursor
	(*DocSnapshot)(nil),                    // 16: google.cloud.conformance.firestore.v1.DocSnapshot
	(*FieldPath)(nil),                      // 17: google.cloud.conformance.firestore.v1.FieldPath
	(*ListenTest)(nil),                     // 18: google.cloud.conformance.firestore.v1.ListenTest
	(*Snapshot)(nil),                       // 19: google.cloud.conformance.firestore.v1.Snapshot
	(*DocChange)(nil),                      // 20: google.cloud.conformance.firestore.v1.DocChange
	(*firestorepb.GetDocumentRequest)(nil), // 21: google.firestore.v1.GetDocumentRequest
	(*firestorepb.CommitRequest)(nil),      // 22: google.firestore.v1.CommitRequest
	(*firestorepb.Precondition)(nil),       // 23: google.firestore.v1.Precondition
	(*firestorepb.StructuredQuery)(nil),    // 24: google.firestore.v1.StructuredQuery
	(*firestorepb.ListenResponse)(nil),     // 25: google.firestore.v1.ListenResponse
	(*firestorepb.Document)(nil),           // 26: google.firestore.v1.Document
	(*timestamppb.Timestamp)(nil),          // 27: google.protobuf.Timestamp
}
var file_tests_proto_depIdxs = []int32{
	2,  // 0: google.cloud.conformance.firestore.v1.TestFile.tests:type_name -> google.cloud.conformance.firestore.v1.Test
	3,  // 1: google.cloud.conformance.firestore.v1.Test.get:type_name -> google.cloud.conformance.firestore.v1.GetTest
	4,  // 2: google.cloud.conformance.firestore.v1.Test.create:type_name -> google.cloud.conformance.firestore.v1.CreateTest
	5,  // 3: google.cloud.conformance.firestore.v1.Test.set:type_name -> google.cloud.conformance.firestore.v1.SetTest
	6,  // 4: google.cloud.conformance.firestore.v1.Test.update:type_name -> google.cloud.conformance.firestore.v1.UpdateTest
	7,  // 5: google.cloud.conformance.firestore.v1.Test.update_paths:type_name -> google.cloud.conformance.firestore.v1.UpdatePathsTest
	8,  // 6: google.cloud.conformance.firestore.v1.Test.delete:type_name -> google.cloud.conformance.firestore.v1.DeleteTest
	10, // 7: google.cloud.conformance.firestore.v1.Test.query:type_name -> google.cloud.conformance.firestore.v1.QueryTest
	18, // 8: google.cloud.conformance.firestore.v1.Test.listen:type_name -> google.cloud.conformance.firestore.v1.ListenTest
	21, // 9: google.cloud.conformance.firestore.v1.GetTest.request:type_name -> google.firestore.v1.GetDocumentRequest
	22, // 10: google.cloud.conformance.firestore.v1.CreateTest.request:type_name -> google.firestore.v1.CommitRequest
	9,  // 11: google.cloud.conformance.firestore.v1.SetTest.option:type_name -> google.cloud.conformance.firestore.v1.SetOption
	22, // 12: google.cloud.conformance.firestore.v1.SetTest.request:type_name -> google.firestore.v1.CommitRequest
	23, // 13: google.cloud.conformance.firestore.v1.UpdateTest.precondition:type_name -> google.firestore.v1.Precondition
	22, // 14: google.cloud.conformance.firestore.v1.UpdateTest.request:type_name -> google.firestore.v1.CommitRequest
	23, // 15: google.cloud.conformance.firestore.v1.UpdatePathsTest.precondition:type_name -> google.firestore.v1.Precondition
	17, // 16: google.cloud.conformance.firestore.v1.UpdatePathsTest.field_paths:type_name -> google.cloud.conformance.firestore.v1.FieldPath
	22, // 17: google.cloud.conformance.firestore.v1.UpdatePathsTest.request:type_name -> google.firestore.v1.CommitRequest
	23, // 18: google.cloud.conformance.firestore.v1.DeleteTest.precondition:type_name -> google.firestore.v1.Precondition
	22, // 19: google.cloud.conformance.firestore.v1.DeleteTest.request:type_name -> google.firestore.v1.CommitRequest
	17, // 20: google.cloud.conformance.firestore.v1.SetOption.fields:type_name -> google.cloud.conformance.firestore.v1.FieldPath
	11, // 21: google.cloud.conformance.firestore.v1.QueryTest.clauses:type_name -> google.cloud.conformance.firestore.v1.Clause
	24, // 22: google.cloud.conformance.firestore.v1.QueryTest.query:type_name -> google.firestore.v1.StructuredQuery
	12, // 23: google.cloud.conformance.firestore.v1.Clause.select:type_name -> google.cloud.conformance.firestore.v1.Select
	13, // 24: google.cloud.conformance.firestore.v1.Clause.where:type_name -> google.cloud.conformance.firestore.v1.Where
	14, // 25: google.cloud.conformance.firestore.v1.Clause.order_by:type_name -> google.cloud.conformance.firestore.v1.OrderBy
	15, // 26: google.cloud.conformance.firestore.v1.Clause.start_at:type_name -> google.cloud.conformance.firestore.v1.Cursor
	15, // 27: google.cloud.conformance.firestore.v1.Clause.start_after:type_name -> google.cloud.conformance.firestore.v1.Cursor
	15, // 28: google.cloud.conformance.firestore.v1.Clause.end_at:type_name -> google.cloud.conformance.firestore.v1.Cursor
	15, // 29: google.cloud.conformance.firestore.v1.Clause.end_before:type_name -> google.cloud.conformance.firestore.v1.Cursor
	17, // 30: google.cloud.conformance.firestore.v1.Select.fields:type_name -> google.cloud.conformance.firestore.v1.FieldPath
	17, // 31: google.cloud.conformance.firestore.v1.Where.path:type_name -> google.cloud.conformance.firestore.v1.FieldPath
	17, // 32: google.cloud.conformance.firestore.v1.OrderBy.path:type_name -> google.cloud.conformance.firestore.v1.FieldPath
	16, // 33: google.cloud.conformance.firestore.v1.Cursor.doc_snapshot:type_name -> google.cloud.conformance.firestore.v1.DocSnapshot
	25, // 34: google.cloud.conformance.firestore.v1.ListenTest.responses:type_name -> google.firestore.v1.ListenResponse
	19, // 35: google.cloud.conformance.firestore.v1.ListenTest.snapshots:type_name -> google.cloud.conformance.firestore.v1.Snapshot
	26, // 36: google.cloud.conformance.firestore.v1.Snapshot.docs:type_name -> google.firestore.v1.Document
	20, // 37: google.cloud.conformance.firestore.v1.Snapshot.changes:type_name -> google.cloud.conformance.firestore.v1.DocChange
	27, // 38: google.cloud.conformance.firestore.v1.Snapshot.read_time:type_name -> google.protobuf.Timestamp
	0,  // 39: google.cloud.conformance.firestore.v1.DocChange.kind:type_name -> google.cloud.conformance.firestore.v1.DocChange.Kind
	26, // 40: google.cloud.conformance.firestore.v1.DocChange.doc:type_name -> google.firestore.v1.Document
	41, // [41:41] is the sub-list for method output_type
	41, // [41:41] is the sub-list for method input_type
	41, // [41:41] is the sub-list for extension type_name
	41, // [41:41] is the sub-list for extension extendee
	0,  // [0:41] is the sub-list for field type_name
}

func init() { file_tests_proto_init() }
func file_tests_proto_init() {
	if File_tests_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_tests_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestFile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Test); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdatePathsTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetOption); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueryTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Clause); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Select); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Where); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocSnapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FieldPath); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListenTest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Snapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_tests_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DocChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_tests_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Test_Get)(nil),
		(*Test_Create)(nil),
		(*Test_Set)(nil),
		(*Test_Update)(nil),
		(*Test_UpdatePaths)(nil),
		(*Test_Delete)(nil),
		(*Test_Query)(nil),
		(*Test_Listen)(nil),
	}
	file_tests_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*Clause_Select)(nil),
		(*Clause_Where)(nil),
		(*Clause_OrderBy)(nil),
		(*Clause_Offset)(nil),
		(*Clause_Limit)(nil),
		(*Clause_StartAt)(nil),
		(*Clause_StartAfter)(nil),
		(*Clause_EndAt)(nil),
		(*Clause_EndBefore)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_tests_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_tests_proto_goTypes,
		DependencyIndexes: file_tests_proto_depIdxs,
		EnumInfos:         file_tests_proto_enumTypes,
		MessageInfos:      file_tests_proto_msgTypes,
	}.Build()
	File_tests_proto = out.File
	file_tests_proto_rawDesc = nil
	file_tests_proto_goTypes = nil
	file_tests_proto_depIdxs = nil
}
