/*
 *  $Id: mac_integration.h 28832 2025-11-07 13:39:29Z yeti-dn $
 *  Copyright (C) 2009 Andrey Gruzdev.
 *  E-mail: gruzdev@ntmdt.ru.
 *
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYDDION_MAC_INTEGRATION_H__
#define __GWYDDION_MAC_INTEGRATION_H__

#include <gtk/gtk.h>

/* NB: You are expected to include config.h before including this header. */
#ifdef HAVE_GTK_MAC_INTEGRATION
void gwyddion_mac_startup   (void);
void gwyddion_mac_shutdown  (void);
void gwyddion_mac_set_locale(void);
void gwyddion_mac_build_menu(GtkWidget *container);
#else
static inline void gwyddion_mac_startup(void) { }
static inline void gwyddion_mac_shutdown(void) { }
static inline void gwyddion_mac_set_locale(void) { }
static inline void gwyddion_mac_build_menu(G_GNUC_UNUSED GtkWidget *container) { }
#endif

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
