% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{configure}
\alias{configure}
\alias{formatArguments}
\title{Configure Cmake}
\usage{
configure(
  c.compiler = TRUE,
  c.flags = c.compiler,
  cxx.compiler = TRUE,
  cxx.flags = cxx.compiler,
  fortran.compiler = TRUE,
  fortran.flags = fortran.compiler,
  cpp.flags = c.compiler || cxx.compiler,
  pic.flags = TRUE,
  ld.flags = c("exe", "module", "shared"),
  make = TRUE,
  ar = TRUE,
  ranlib = TRUE,
  release.build = TRUE
)

formatArguments(options)
}
\arguments{
\item{c.compiler}{Logical scalar indicating whether to propagate R's choice of C compiler.}

\item{c.flags}{Logical scalar indicating whether to propagate R's choice of C flags.}

\item{cxx.compiler}{Logical scalar indicating whether to propagate R's choice of C++ compiler.}

\item{cxx.flags}{Logical scalar indicating whether to propagate R's choice of C++ flags.}

\item{fortran.compiler}{Logical scalar indicating whether to propagate R's choice of Fortran compiler.}

\item{fortran.flags}{Logical scalar indicating whether to propagate R's choice of Fortran flags.}

\item{cpp.flags}{Logical scalar indicating whether to propagate R's choice of C/C++ preprocessing flags.}

\item{pic.flags}{Logical scalar indicating whether to propagate R's choice of each language's position-independent flags.
This also sets the \code{CMAKE_POSITION_INDEPENDENT_CODE} variable.}

\item{ld.flags}{Logical scalar indicating whether to add R's choice of linker flags to the CMake variables for each target type.}

\item{make}{Logical scalar indicating whether to propagate R's choice of \code{make} command.}

\item{ar}{Logical scalar indicating whether to propagate R's choice of command to make static libraries.}

\item{ranlib}{Logical scalar indicating whether to propagate R's choice of command to index static libraries.}

\item{release.build}{Logical scalar indicating whether to configure Cmake for a release build.
Note that this has no effect on Windows, where the release flags must be set during the build itself.}

\item{options}{Character vector of optional arguments from \code{configure}.}
}
\value{
For \code{configure}, a named character vector containing the name and value of each option.

For \code{formatArguments}, a character vector with Cmake arguments on the command line.
\code{NA} values are ignored, and values with spaces or empty strings are quoted.
}
\description{
Propagate R's configuration variables into the Cmake options, where possible.
}
\examples{
options <- configure()
options
formatArguments(options)

}
\author{
Aaron Lun
}
