% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.regression.R
\name{binregG}
\alias{binregG}
\title{G-estimator for binomial regression model (Standardized estimates)}
\usage{
binregG(x, data, Avalues = NULL, varname = NULL)
}
\arguments{
\item{x}{binreg object}

\item{data}{data frame for risk averaging}

\item{Avalues}{values to compare for first covariate A, assumes that first variable is factor and take all levels}

\item{varname}{if given then averages for this variable, default is first variable}
}
\description{
Computes G-estimator \deqn{ \hat F(t,A=a) = n^{-1} \sum_i \hat F(t,A=a,Z_i) }.
Assumes that the first covariate is $A$.
Gives influence functions of these risk estimates and SE's are based on these.  
If first covariate is a factor then all contrast are computed, and if continuous 
then considered covariate values are given by Avalues.
}
\examples{
library(mets)
data(bmt); bmt$time <- bmt$time+runif(408)*0.001
bmt$event <- (bmt$cause!=0)*1

b1 <- binreg(Event(time,cause)~age+tcell+platelet,bmt,cause=1,time=50)
sb1 <- binregG(b1,bmt,Avalues=c(0,1,2))
summary(sb1)
}
\references{
Blanche PF, Holt A, Scheike T (2022). “On logistic regression with right censored data, with or without competing risks, and its use for estimating treatment effects.” Lifetime data analysis,
29, 441–482.
}
\author{
Thomas Scheike
}
