% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode2integer.r
\name{recode2integer}
\alias{recode2integer}
\title{recode2integer}
\usage{
recode2integer(y, precision = 7, ftable = TRUE)
}
\arguments{
\item{y}{a numeric, factor, or character vector with no \code{NA}s}

\item{precision}{number of places to the right of the decimal place to round \code{y} if \code{y} is numeric but not integer, for the purpose of finding the distinct values.  Real values rounding to the same values under \code{precision} are mapped to the same integer output \code{y}}

\item{ftable}{set to \code{FALSE} to suppress creation of \code{freq}}
}
\value{
a list with the following elements:
\itemize{
\item \code{y}: vector of integer-coded \code{y}
\item \code{ylevels}: vector of corresponding original \code{y} values, possibly rounded to \code{precision}.  This vector is numeric unless \code{y} is \code{factor} or character, in which case it is a character vector.
\item \code{freq}: frequency table of rounded or categorical \code{y}, with \code{names} attribute for the (possibly rounded) \code{y} levels of the frequencies
\item \code{median}: median \code{y} from original values if numeric, otherwise median of the new integer codes for \code{y}
\item \code{whichmedian}: the integer valued \code{y} that most closely corresponds to \code{median}; for an ordinal regression model this represents one plus the index of the intercept vector corresponding to \code{median}.
}
}
\description{
Create Ordinal Variables With a Given Precision
}
\details{
For a factor variable \code{y}, uses existing factor levels and codes the output \code{y} as integer.  For a character \code{y}, converts to \code{factor} and does the same.  For a numeric \code{y} that is integer, leaves the levels intact and codes \code{y} as consecutive positive integers corresponding to distinct values in the data.  For numeric \code{y} that contains any non-integer values, rounds \code{y} to \code{precision} decimal places to the right before finding the distinct values.

This function is used to prepare ordinal variables for \code{\link[=orm.fit]{orm.fit()}} and \code{\link[=lrm.fit]{lrm.fit()}}.  It was written because just using \code{\link[=factor]{factor()}} creates slightly different distinct \code{y} levels on different hardware because \code{\link[=factor]{factor()}} uses \code{\link[=unique]{unique()}} which functions slightly differently on different systems when there are non-significant digits in floating point numbers.  See \href{https://hbiostat.org/r/rms/unique-float/}{this} for more details.
}
\examples{
w <- function(y, precision=7) {
  v <- recode2integer(y, precision);
  print(v)
  print(table(y, ynew=v$y))
}
set.seed(1)
w(sample(1:3, 20, TRUE))
w(sample(letters[1:3], 20, TRUE))
y <- runif(20)
w(y)
w(y, precision=2)
}
\author{
Cole Beck
}
