// license:BSD-3-Clause
// copyright-holders:David Haywood

#include "emu.h"
#include "arcompact_helper.ipp"

// #######################################################################################################################
//                                 IIII I$$$ sssS SSSS
// NOP_S                           0111 1000 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_NOP_S(uint16_t op)
{
	return m_pc + 2;
}

// #######################################################################################################################
// Unimplemented Instruction, same as illegal, but recommended to fill blank space
//                                 IIII I$$$ sssS SSSS
// UNIMP_S                         0111 1001 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_UNIMP_S(uint16_t op)
{
	fatalerror("UNIMP_S");
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII I$$$ sssS SSSS
// JEQ_S [blink]                   0111 1100 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_JEQ_S_blink(uint16_t op)
{
	if (status32_check_z())
	{
		return m_regs[REG_BLINK];
	}
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII I$$$ sssS SSSS
// JNE_S [blink]                   0111 1101 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_JNE_S_blink(uint16_t op)
{
	if (!status32_check_z())
	{
		return m_regs[REG_BLINK];
	}
	return m_pc + 2;
}

// #######################################################################################################################
//                                 IIII I$$$ sssS SSSS
// J_S [blink]                     0111 1110 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_J_S_blink(uint16_t op) // J_S [blink]
{
	return m_regs[REG_BLINK];
}

// #######################################################################################################################
//                                 IIII I$$$ sssS SSSS
// J_S.D [blink]                   0111 1111 1110 0000
// #######################################################################################################################

uint32_t arcompact_device::handleop_J_S_D_blink(uint16_t op) // J_S.D [blink]
{
	m_delayactive = true;
	m_delayjump = m_regs[REG_BLINK];
	m_delaylinks = false;
	return m_pc + 2;
}
