/*----- PROTECTED REGION ID(IfchangeServer::DynAttrUtils.cpp) ENABLED START -----*/
static const char *RcsId = "$Id:  $";
//=============================================================================
//
// file :        IfchangeServerDynAttrUtils.cpp
//
// description : Dynamic attributes utilities file for the IfchangeServer class
//
// project :
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <IfchangeServer.h>
#include <IfchangeServerClass.h>

/*----- PROTECTED REGION END -----*/ //	IfchangeServer::DynAttrUtils.cpp

//================================================================
//  Attributes managed is:
//================================================================
//  ioattr  |  Tango::DevDouble	Scalar
//================================================================

//	For compatibility reason, this file (IfchangeServerDynAttrUtils)
//	manage also the dynamic command utilities.
//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//================================================================
//  iocmd         |  iocmd
//================================================================

namespace IfchangeServer_ns
{
//=============================================================
//	Add/Remove dynamic attribute methods
//=============================================================

//--------------------------------------------------------
/**
 *	Add a ioattr dynamic attribute.
 *
 *  parameter attname: attribute name to be cretated and added.
 */
//--------------------------------------------------------
void IfchangeServer::add_ioattr_dynamic_attribute(string attname)
{
    //	Attribute : ioattr
    ioattrAttrib *ioattr = new ioattrAttrib(attname);
    Tango::UserDefaultAttrProp ioattr_prop;
    //	description	not set for ioattr
    //	label	not set for ioattr
    //	unit	not set for ioattr
    //	standard_unit	not set for ioattr
    //	display_unit	not set for ioattr
    //	format	not set for ioattr
    //	max_value	not set for ioattr
    //	min_value	not set for ioattr
    //	max_alarm	not set for ioattr
    //	min_alarm	not set for ioattr
    //	max_warning	not set for ioattr
    //	min_warning	not set for ioattr
    //	delta_t	not set for ioattr
    //	delta_val	not set for ioattr

    /*----- PROTECTED REGION ID(IfchangeServer::att_ioattr_dynamic_attribute) ENABLED START -----*/

    /*----- PROTECTED REGION END -----*/ //	IfchangeServer::att_ioattr_dynamic_attribute
    ioattr->set_default_properties(ioattr_prop);
    //	Not Polled
    ioattr->set_disp_level(Tango::OPERATOR);
    //	Not Memorized
    ioattr_data.insert(make_pair(attname, 0.0));
    add_attribute(ioattr);
}

//--------------------------------------------------------
/**
 *	remove a ioattr dynamic attribute.
 *
 *  parameter attname: attribute name to be removed.
 */
//--------------------------------------------------------
void IfchangeServer::remove_ioattr_dynamic_attribute(string attname)
{
    remove_attribute(attname, true, Tango::Util::instance()->_UseDb);
    map<string, Tango::DevDouble>::iterator ite;
    if((ite = ioattr_data.find(attname)) != ioattr_data.end())
    {
        /*----- PROTECTED REGION ID(IfchangeServer::remove_ioattr_dynamic_attribute) ENABLED START -----*/

        /*----- PROTECTED REGION END -----*/ //	IfchangeServer::remove_ioattr_dynamic_attribute
        ioattr_data.erase(ite);
    }
}

//============================================================
//	Tool methods to get pointer on attribute data buffer
//============================================================
//--------------------------------------------------------
/**
 *	Return a pointer on ioattr data.
 *
 *  parameter attname: the specified attribute name.
 */
//--------------------------------------------------------
Tango::DevDouble *IfchangeServer::get_ioattr_data_ptr(string &name)
{
    map<string, Tango::DevDouble>::iterator ite;
    if((ite = ioattr_data.find(name)) == ioattr_data.end())
    {
        TangoSys_OMemStream tms;
        tms << "Dynamic attribute " << name << " has not been created";
        Tango::Except::throw_exception((const char *) "ATTRIBUTE_NOT_FOUND",
                                       tms.str().c_str(),
                                       (const char *) "IfchangeServer::get_ioattr_data_ptr()");
    }
    return &(ite->second);
}

//=============================================================
//	Add/Remove dynamic command methods
//=============================================================

//--------------------------------------------------------
/**
 *	Add a iocmd dynamic command.
 *
 *  parameter cmdname: command name to be cretated and added.
 *  parameter device:  Set this flag to true if the command must be added for only this device.
 */
//--------------------------------------------------------
void IfchangeServer::add_iocmd_dynamic_command(string cmdname, bool device)
{
    iocmdClass *piocmdCmd = new iocmdClass(cmdname.c_str(), Tango::DEV_VOID, Tango::DEV_VOID, "", "", Tango::OPERATOR);
    add_command(piocmdCmd, device);
}

//--------------------------------------------------------
/**
 *	remove a iocmd dynamic command.
 *
 *  parameter cmdname: command name to be removed.
 */
//--------------------------------------------------------
void IfchangeServer::remove_iocmd_dynamic_command(string cmdname)
{
    remove_command(cmdname, true);
}

} // namespace IfchangeServer_ns
