<!-- omit in toc -->
# Contributing to mashumaro

First off, thanks for taking the time to contribute! ❤️

All types of contributions are encouraged and valued. See the [Table of Contents](#table-of-contents) for different ways to help and details about how this project handles them. Please make sure to read the relevant section before making your contribution. It will make it a lot easier for us maintainers and smooth out the experience for all involved. The community looks forward to your contributions. 🎉

> And if you like the project, but just don't have time to contribute, that's fine. There are other easy ways to support the project and show your appreciation, which we would also be very happy about:
> - Star the project
> - Tweet about it
> - Refer this project in your project's readme
> - Mention the project at local meetups and tell your friends/colleagues

<!-- omit in toc -->
## Table of Contents

- [I Have a Question](#i-have-a-question)
- [I Want To Contribute](#i-want-to-contribute)
  - [Reporting Bugs](#reporting-bugs)
  - [Suggesting Enhancements](#suggesting-enhancements)
  - [Your First Code Contribution](#your-first-code-contribution)
  - [Improving The Documentation](#improving-the-documentation)



## I Have a Question

> If you want to ask a question, we assume that you have read the available [Documentation](https://github.com/Fatal1ty/mashumaro/blob/master/README.md).

Before you ask a question, it is best to search for existing [Issues](https://github.com/Fatal1ty/mashumaro/issues) that might help you. In case you have found a suitable issue and still need clarification, you can write your question in this issue. It is also advisable to search the internet for answers first.

If you then still feel the need to ask a question and need clarification, we recommend the following:

- Open an [Issue](https://github.com/Fatal1ty/mashumaro/issues/new).
- Provide as much context as you can about what you're running into.
- Provide project and platform versions (nodejs, npm, etc), depending on what seems relevant.
- Tag your issue with the `question` tag

We will then take care of the issue as soon as possible.

## I Want To Contribute

> ### Legal Notice <!-- omit in toc -->
> When contributing to this project, you must agree that you have authored 100% of the content, that you have the necessary rights to the content and that the content you contribute may be provided under the project licence.

### Reporting Bugs

<!-- omit in toc -->
#### Before Submitting a Bug Report

A good bug report shouldn't leave others needing to chase you up for more information. Therefore, we ask you to investigate carefully, collect information and describe the issue in detail in your report. Please complete the following steps in advance to help us fix any potential bug as fast as possible.

- Make sure that you are using the latest version.
- Determine if your bug is really a bug and not an error on your side e.g. using incompatible environment components/versions (Make sure that you have read the [documentation](https://github.com/Fatal1ty/mashumaro/blob/master/README.md). If you are looking for support, you might want to check [this section](#i-have-a-question)).
- To see if other users have experienced (and potentially already solved) the same issue you are having, check if there is not already a bug report existing for your bug or error in the [bug tracker](https://github.com/Fatal1ty/mashumaro/issues?q=label%3Abug).
- Also make sure to search the internet (including Stack Overflow) to see if users outside the GitHub community have discussed the issue.
- Collect information about the bug:
  - Stack trace (Traceback)
  - OS, Platform and Version (Windows, Linux, macOS, x86, ARM)
  - Version of the interpreter, compiler, SDK, runtime environment, package manager, depending on what seems relevant.
  - Possibly your input and the output
  - Can you reliably reproduce the issue? And can you also reproduce it with older versions?

<!-- omit in toc -->
#### How Do I Submit a Good Bug Report?

> You must never report security related issues, vulnerabilities or bugs including sensitive information to the issue tracker, or elsewhere in public. Instead sensitive bugs must be reported in accordance with our [security policy](https://github.com/Fatal1ty/mashumaro/security/policy).

We use GitHub issues to track bugs and errors. If you run into an issue with the project:

- Open an [Issue](https://github.com/Fatal1ty/mashumaro/issues/new?template=bug_report.md). (Since we can't be sure at this point whether it is a bug or not, we ask you not to talk about a bug yet and not to label the issue.)
- Explain the behavior you would expect and the actual behavior.
- Please provide as much context as possible and describe the *reproduction steps* that someone else can follow to recreate the issue on their own. This usually includes your code. For good bug reports you should isolate the problem and create a reduced test case.
- Provide the information you collected in the previous section.

Once it's filed:

- The project team will label the issue accordingly.
- A team member will try to reproduce the issue with your provided steps. If there are no reproduction steps or no obvious way to reproduce the issue, the team will ask you for those steps and mark the issue as `needs information`. Bugs with the `needs information` tag will not be addressed until they are reproduced.
- If the team is able to reproduce the issue, it will be labeled with the `bug` tag, as well as possibly other tags, and the issue will be left to be [implemented by someone](#your-first-code-contribution).


### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for mashumaro, **including completely new features and minor improvements to existing functionality**. Following these guidelines will help maintainers and the community to understand your suggestion and find related suggestions.

<!-- omit in toc -->
#### Before Submitting an Enhancement

- Make sure that you are using the latest version.
- Read the [documentation](https://github.com/Fatal1ty/mashumaro/blob/master/README.md) carefully and find out if the functionality is already covered, maybe by an individual configuration.
- Perform a [search](https://github.com/Fatal1ty/mashumaro/issues) to see if the enhancement has already been suggested. If it has, add a comment to the existing issue instead of opening a new one.
- Find out whether your idea fits with the scope and aims of the project. It's up to you to make a strong case to convince the project's developers of the merits of this feature. Keep in mind that we want features that will be useful to the majority of our users and not just a small subset. If you're just targeting a minority of users, consider writing an add-on/plugin library.

<!-- omit in toc -->
#### How Do I Submit a Good Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://github.com/Fatal1ty/mashumaro/issues?q=is%3Aissue+is%3Aopen+label%3Aenhancement) with the `enhancement` tag.

- Open an [Feature Request](https://github.com/Fatal1ty/mashumaro/issues/new?template=feature_request.md).
- Use a **clear and descriptive title** for the issue to identify the suggestion.
- Provide a **step-by-step description of the suggested enhancement** in as many details as possible.
- **Describe the current behavior** and **explain which behavior you expected to see instead** and why. At this point you can also tell which alternatives do not work for you.
- **Explain why this enhancement would be useful** to most mashumaro users. You may also want to point out the other projects that solved it better and which could serve as inspiration.

### Your First Code Contribution

> Please, refrain from creating a new pull request without an existing related issue that your pull request solves. Minor corrections, such as spelling errors, may be an exception.

#### How to Get Started

1. Finding an Issue: Browse through our repository and look for issues you may help with. If you're new to open source and looking for a good starting point, we have a special label called [`good first issue`](https://github.com/Fatal1ty/mashumaro/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) that highlights issues that are ideal for beginners to tackle.
2. Understanding the Issue: Once you've found a good issue, take the time to read through the description and understand what needs to be done. Feel free to ask questions if anything is unclear.
3. Setting up your Development Environment: Follow [the instructions](#setting-up-your-development-environment) to set up your development environment. Make sure you have all the necessary tools and dependencies installed.
4. Making your Contribution: Fork the repository, create a new branch for your changes, and start working on the issue. Make sure to follow our coding guidelines and best practices.
5. Submitting your Pull Request: Once you're done with your changes, submit a pull request back to the main repository. Be sure to reference the issue you're addressing in your pull request description.

### What Can You Help With?

Here are some common areas where you can make contributions:

- Fixing bugs or issues reported by users
- Implementing new features or enhancements
- Improving the documentation
- Refactoring code for better readability and performance

Remember, everyone starts somewhere, and we're here to support you on your journey to becoming a contributor. If you have any questions or need help along the way, feel free to reach out to our team or community members for assistance.

#### Setting up your Development Environment

Before getting started, you will need to have already installed:
* [python](https://www.python.org) (3.9+ only)
* [git](https://git-scm.com)
* [just](https://github.com/casey/just)

Once you have those installed, you're ready to:
* Clone the repository
* Create a virtual environment
* Install all development dependencies
* Install a development version of mashumaro

> Please note that you can use any virtual management tool you like. Here we show the basic instructions using the standard `venv` library.

```shell
# Clone the repository
git clone https://github.com/Fatal1ty/mashumaro

# cd into the repo root directory
cd mashumaro/

# Create and activate a virtual environment (recommended)
python -m venv env && source env/bin/activate

# Install mashumaro and all development dependencies
just build
```

#### Linters

To run linters, use the following command:

```shell
just lint
```

#### Format the code

To format the code according to style guides, use the following command:

```shell
just format
```

#### Testing

Tests are located in the `tests/` directory. Any code changes should include additional tests or modification of existing tests to ensure correctness.

To run tests locally, use the following command:

```shell
just test
```

Please make sure that test coverage has not decreased after your changes. Also note that test coverage depends on the Python version that your virtual environment was created with, since not all functionality works on every supported version of Python. To run tests with coverage report, you can use the following command:

```shell
just test-with-coverage
```

#### Continuous integration

We use GitHub Actions to provide "continuous integration" testing for all pull requests. When submitting a pull request, please check that all tests are passing and fix any issues that may arise.

### Improving The Documentation

We welcome contributions to improve the documentation of this project. Whether it's fixing typos, clarifying instructions, adding examples, or creating new sections, your help is greatly appreciated. Here are some ways you can contribute to improving the documentation:

1. Fixing Typos and Grammar: If you notice any typos or grammatical errors in the documentation, feel free to submit a pull request with the corrections.
2. Clarifying Instructions: If you find any instructions that are unclear or ambiguous, you can suggest improvements to make them more understandable for other users.
3. Adding Examples: Providing code examples or step-by-step guides can be very helpful for users trying to understand how to use the project. Feel free to add examples where needed.
4. Creating New Sections: If you think there are important topics missing from the documentation, you can create new sections to cover those topics.
5. Updating Outdated Information: If any information in the documentation is outdated or no longer accurate, please update it with the correct information.
