/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <comphelper/base64.hxx>
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#include <com/sun/star/uno/XComponentContext.hpp>
#include <rtl/ustrbuf.hxx>
#include <sal/log.hxx>
#include <xmloff/namespacemap.hxx>
#include <xmloff/xmlnamespace.hxx>
#include <xmloff/xmltoken.hxx>
#include "DeepTContext.hxx"
#include "MetaTContext.hxx"
#include "DocumentTContext.hxx"
#include "NotesTContext.hxx"
#include "StyleOASISTContext.hxx"
#include "FrameOASISTContext.hxx"
#include "EventOASISTContext.hxx"
#include "DlgOASISTContext.hxx"
#include "ControlOASISTContext.hxx"
#include "FormPropOASISTContext.hxx"
#include "ChartOASISTContext.hxx"
#include "ChartPlotAreaOASISTContext.hxx"
#include "MutableAttrList.hxx"
#include "ElemTransformerAction.hxx"
#include "AttrTransformerAction.hxx"
#include "TransformerActions.hxx"
#include "FamilyType.hxx"
#include "Oasis2OOo.hxx"
#include <cppuhelper/supportsservice.hxx>

using namespace ::xmloff::token;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::beans;

namespace {

enum XMLUserDefinedTransformerAction
{
    XML_ETACTION_META=XML_ETACTION_USER_DEFINED,
    XML_ETACTION_DOCUMENT,
    XML_ETACTION_BODY,
    XML_ETACTION_NOTES,
    XML_ETACTION_TABLE,
    XML_ETACTION_STYLE,
    XML_ETACTION_STYLE_RENAME,
    XML_ETACTION_FRAME,
    XML_ETACTION_EVENT,
    XML_ETACTION_DLG,
    XML_ETACTION_TAB_STOP,
    XML_ETACTION_FORM_CONTROL,
    XML_ETACTION_FORM_PROPERTY,
    XML_ETACTION_CONFIG_ITEM,
    XML_ETACTION_TRACKED_CHANGES,
    XML_ETACTION_CHART,
    XML_ETACTION_CHART_PLOT_AREA
};

}

#define ENTRY3( n, l, a, p1, p2, p3 ) \
    { n, l, a, p1, p2, p3 }
#define ENTRY3QNQ( n, l, a, n1, l1, p2, n3, l3 ) \
    ENTRY3( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), \
            p2, XMLTransformerActionInit::QNameParam( n3, l3 ) )

#define ENTRY2( n, l, a, p1, p2 ) \
    ENTRY3( n, l, a, p1, p2, 0 )
#define ENTRY2QN( n, l, a, n1, l1, p2 ) \
    ENTRY2( n, l, a, XMLTransformerActionInit::QNameParam( n1, l1 ), p2 )

#define ENTRY1( n, l, a, p1 ) \
    ENTRY3( n, l, a, p1, 0, 0 )
#define ENTRY1Q( n, l, a, p1, t1 ) \
    ENTRY1( n, l, a, XMLTransformerActionInit::QNameParam( p1, t1 ) )

#define ENTRY0( n, l, a ) \
    ENTRY3( n, l, a, 0, 0, 0 )

// a macro to put two tokens into one sal_Int32 for the action
// XML_ATACTION_RENAME_ATTRIBUTE
static constexpr sal_Int32 RENAME_ENTRY( XMLTokenEnum f, XMLTokenEnum s )
{
    return static_cast< sal_Int32 >(f) | (static_cast< sal_Int32 >(s) << 16);
}

XMLTransformerActionInit const aActionTable[] =
{
    // add office:class from <office:document> and <office:document-content>
    ENTRY0( XML_NAMESPACE_OFFICE, XML_DOCUMENT, XML_ETACTION_DOCUMENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_DOCUMENT_CONTENT, XML_ETACTION_DOCUMENT ),
    ENTRY1Q( XML_NAMESPACE_OOO, XML_AUTO_TEXT_EVENTS, XML_ETACTION_RENAME_ELEM,
                          XML_NAMESPACE_OFFICE, XML_AUTO_TEXT_EVENTS),

    // add <meta:keywords>
    ENTRY0( XML_NAMESPACE_OFFICE, XML_META, XML_ETACTION_META ),

    // rename <office:scripts> to <office:script>
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_SCRIPTS, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OFFICE, XML_SCRIPT ),

    // rename <office:script> to <office:script-data> and process attributes
    ENTRY2QN( XML_NAMESPACE_OFFICE, XML_SCRIPT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_OFFICE, XML_SCRIPT_DATA,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:libraries> to <script:libraries>
    ENTRY1Q( XML_NAMESPACE_OOO, XML_LIBRARIES, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARIES ),

    // rename <ooo:library-linked> to <script:library-linked> and process attributes
    ENTRY2QN( XML_NAMESPACE_OOO, XML_LIBRARY_LINKED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARY_LINKED,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:library-embedded> to <script:library-embedded> and process attributes
    ENTRY2QN( XML_NAMESPACE_OOO, XML_LIBRARY_EMBEDDED, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_LIBRARY_EMBEDDED,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:module> to <script:module> and process attributes
    ENTRY2QN( XML_NAMESPACE_OOO, XML_MODULE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_SCRIPT, XML_MODULE,
                        OASIS_SCRIPT_ACTIONS ),

    // rename <ooo:source-code> to <script:source-code>
    ENTRY1Q( XML_NAMESPACE_OOO, XML_SOURCE_CODE, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_SCRIPT, XML_SOURCE_CODE ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_BODY, XML_ETACTION_BODY ),

    // rename <office:font-face-decls> to <office:font-decl>,
    // rename <style:font-face> to <style:font-decl>, process attrs
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_FONT_FACE_DECLS, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_OFFICE, XML_FONT_DECLS ),
    ENTRY2QN( XML_NAMESPACE_STYLE, XML_FONT_FACE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
                        XML_NAMESPACE_STYLE, XML_FONT_DECL,
                           OASIS_FONT_FACE_ACTIONS ),

    // remove genre element
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TEXT, XML_ETACTION_COPY_CONTENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_DRAWING, XML_ETACTION_COPY_CONTENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_PRESENTATION, XML_ETACTION_COPY_CONTENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_SPREADSHEET, XML_ETACTION_COPY_CONTENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_CHART, XML_ETACTION_COPY_CONTENT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_IMAGE, XML_ETACTION_COPY_CONTENT ),

    // rename <style:page-layout> to <style:page-master>
    // ENTRY1Q( STYLE, PAGE_LAYOUT, RENAME_ELEM,
    //                      XML_NAMESPACE_STYLE, XML_PAGE_MASTER ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_MASTER_PAGE, XML_ETACTION_PROC_ATTRS,
                        OASIS_MASTER_PAGE_ACTIONS ),

    // merge <style:*-properties> into <style:properties> and do other
    // styles processing
    ENTRY1( XML_NAMESPACE_STYLE, XML_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_DEFAULT_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_END ),
    ENTRY2QN( XML_NAMESPACE_STYLE, XML_PAGE_LAYOUT, XML_ETACTION_STYLE_RENAME,
                        XML_NAMESPACE_STYLE, XML_PAGE_MASTER,
                          XML_FAMILY_TYPE_PAGE_LAYOUT ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_NUMBER_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_CURRENCY_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_PERCENTAGE_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_DATE_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_TIME_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_BOOLEAN_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_NUMBER, XML_TEXT_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_DATA ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_LIST_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_LIST ),
//  ENTRY0( XML_NAMESPACE_TEXT, XML_OUTLINE_STYLE, STYLE ),

    ENTRY1( XML_NAMESPACE_STYLE, XML_HEADER_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_HEADER_FOOTER ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_FOOTER_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_HEADER_FOOTER ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_LIST_LEVEL_STYLE_NUMBER, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_LIST ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_LIST_LEVEL_STYLE_BULLET, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_LIST ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_LIST_LEVEL_STYLE_IMAGE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_LIST ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_OUTLINE_LEVEL_STYLE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_LIST ),
    ENTRY1( XML_NAMESPACE_DRAW, XML_GRADIENT, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_GRADIENT ),
    ENTRY1( XML_NAMESPACE_DRAW, XML_FILL_IMAGE, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_FILL_IMAGE ),
    ENTRY2QN( XML_NAMESPACE_DRAW, XML_OPACITY, XML_ETACTION_STYLE_RENAME,
                XML_NAMESPACE_DRAW, XML_TRANSPARENCY,
                 XML_FAMILY_TYPE_GRADIENT ),
    ENTRY1( XML_NAMESPACE_DRAW, XML_MARKER, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_MARKER ),
    ENTRY1( XML_NAMESPACE_DRAW, XML_HATCH, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_HATCH ),
    ENTRY1( XML_NAMESPACE_DRAW, XML_STROKE_DASH, XML_ETACTION_STYLE,
                 XML_FAMILY_TYPE_STROKE_DASH ),

    // process <text:h/p>: process style-name attributes,
    // rename <text:h>'s text:outline-level to text:level,
    ENTRY1( XML_NAMESPACE_TEXT, XML_H, XML_ETACTION_PROC_ATTRS, OASIS_PARA_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_P, XML_ETACTION_PROC_ATTRS, OASIS_PARA_ACTIONS ),

    // process <test:list>'s text:style-name attributes
    // rename <text:list> to <text:ordered-list> or <text:unordered-list>
    // TODO: All list currently are renamed to <text:ordered-list>
    ENTRY2QN( XML_NAMESPACE_TEXT, XML_LIST, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
            XML_NAMESPACE_TEXT, XML_ORDERED_LIST,
            OASIS_LIST_STYLE_REF_ACTIONS ),

    // rename <text:note*> to <text:footnote*> or <text:endnote*>
    ENTRY1( XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION, XML_ETACTION_NOTES,
                                                    XML_NOTES_CONFIGURATION),
    ENTRY1( XML_NAMESPACE_TEXT, XML_NOTE, XML_ETACTION_NOTES, XML_NOTE ),

    // rename <text:footnote> and <text:endnote> to <text:note>
    ENTRY1( XML_NAMESPACE_TEXT, XML_NOTE_REF, XML_ETACTION_NOTES, XML_NOTE_REF ),

    // rename <text:tab> to <text:tab-stop>
    ENTRY1Q( XML_NAMESPACE_TEXT, XML_TAB, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_TEXT, XML_TAB_STOP ),

    // replace <table:table table:is-sub-table> with <table:sub-table>
    ENTRY0( XML_NAMESPACE_TABLE, XML_TABLE, XML_ETACTION_TABLE ),

    // merge frame element
    ENTRY0( XML_NAMESPACE_DRAW, XML_FRAME, XML_ETACTION_FRAME ),

    // process events
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_EVENT_LISTENERS, XML_ETACTION_RENAME_ELEM,
                      XML_NAMESPACE_OFFICE, XML_EVENTS ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_EVENT_LISTENER, XML_ETACTION_EVENT ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_EVENT, XML_ETACTION_EVENT ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_EVENT_LISTENER, XML_ETACTION_EVENT ),

    // process Basic dialogs
    ENTRY0( XML_NAMESPACE_DLG, XML_STYLE, XML_ETACTION_DLG ),

    // process length attributes
    ENTRY1( XML_NAMESPACE_DRAW,  XML_RECT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_LINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_POLYLINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_PATH, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CIRCLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_ELLIPSE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CONNECTOR, XML_ETACTION_PROC_ATTRS, OASIS_CONNECTOR_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CAPTION, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_MEASURE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CONTROL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_PAGE_THUMBNAIL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_G, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
//  ENTRY1( XML_NAMESPACE_DRAW,  XML_FRAME, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_TEXT_BOX, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_PLACEHOLDER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CONTOUR_POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_CONTOUR_PATH, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_AREA_RECTANGLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_AREA_CIRCLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_AREA_POLYGON, XML_ETACTION_PROC_ATTRS, OASIS_DRAW_AREA_POLYGON_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DRAW,  XML_GLUE_POINT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,  XML_SCENE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,  XML_CUBE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,  XML_SPHERE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,  XML_EXTRUDE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_DR3D,  XML_ROTATE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_TITLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_SUBTITLE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_FOOTER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_LEGEND, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_WALL, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_FLOOR, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_AXIS, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_GRID, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_SERIES, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_DATA_POINT, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_MEAN_VALUE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_ERROR_INDICATOR, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_REGRESSION_CURVE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_STOCK_GAIN_MARKER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_STOCK_LOSS_MARKER, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),
    ENTRY1( XML_NAMESPACE_CHART, XML_STOCK_RANGE_LINE, XML_ETACTION_PROC_ATTRS, OASIS_SHAPE_ACTIONS ),

    ENTRY0( XML_NAMESPACE_CHART, XML_CHART, XML_ETACTION_CHART ),
    ENTRY0( XML_NAMESPACE_CHART, XML_PLOT_AREA, XML_ETACTION_CHART_PLOT_AREA ),

    ENTRY0( XML_NAMESPACE_CONFIG, XML_CONFIG_ITEM, XML_ETACTION_CONFIG_ITEM ),
    ENTRY1Q( XML_NAMESPACE_TEXT,  XML_TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
                        XML_NAMESPACE_TEXT, XML_PROTECTION_KEY ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_TRACKED_CHANGES, XML_ETACTION_TRACKED_CHANGES,
                        XML_NAMESPACE_TABLE, XML_PROTECTION_KEY ),

    ENTRY1( XML_NAMESPACE_TEXT,  XML_INDEX_ENTRY_TAB_STOP, XML_ETACTION_PROC_ATTRS,
                  OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS ),
    ENTRY0( XML_NAMESPACE_STYLE, XML_TAB_STOP, XML_ETACTION_TAB_STOP ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE, XML_ETACTION_PROC_ATTRS,
                     OASIS_BACKGROUND_IMAGE_ACTIONS  ),
    ENTRY1( XML_NAMESPACE_TEXT,  XML_LINENUMBERING_CONFIGURATION, XML_ETACTION_PROC_ATTRS,
                  OASIS_LINENUMBERING_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_FOOTNOTE_SEP, XML_ETACTION_PROC_ATTRS,
                   OASIS_FOOTNOTE_SEP_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_DROP_CAP, XML_ETACTION_PROC_ATTRS, OASIS_DROP_CAP_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_COLUMNS, XML_ETACTION_PROC_ATTRS, OASIS_COLUMNS_ACTIONS ),
    ENTRY1( XML_NAMESPACE_STYLE, XML_COLUMN, XML_ETACTION_PROC_ATTRS, OASIS_COLUMNS_ACTIONS ),

    // process *:style-name attributes
    ENTRY1( XML_NAMESPACE_STYLE, XML_MAP, XML_ETACTION_PROC_ATTRS, OASIS_MAP_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_SPAN, XML_ETACTION_PROC_ATTRS, OASIS_TEXT_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_A, XML_ETACTION_PROC_ATTRS, OASIS_TEXT_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_RUBY_TEXT, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_TABLE_OF_CONTENT_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_ILLUSTRATION_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_TABLE_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_OBJECT_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_USER_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_ALPHABETICAL_INDEX_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_BIBLIOGRAPHY_ENTRY_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_SOURCE_STYLE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_TITLE_TEMPLATE, XML_ETACTION_PROC_ATTRS,
                OASIS_PARA_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY3QNQ( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_CHAPTER,
            XML_ETACTION_RENAME_ELEM_PROC_ATTRS_COND,
            XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_CHAPTER_NUMBER,
            OASIS_TEXT_STYLE_REF_ACTIONS ,
               XML_NAMESPACE_TEXT, XML_TABLE_OF_CONTENT_ENTRY_TEMPLATE),
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_TEXT, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_PAGE_NUMBER, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_SPAN, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_BIBLIOGRAPHY, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_LINK_START, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_INDEX_ENTRY_LINK_END, XML_ETACTION_PROC_ATTRS,
                OASIS_TEXT_STYLE_REF_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_DRAW, XML_PAGE, XML_ETACTION_PROC_ATTRS,
                OASIS_MASTER_PAGE_REF_ACTIONS ), /* generated entry */
    // Conversion of attribute <table:style-name> for <table:table-row> and
    // <table:table-column> (#i40011#, #i40015#)
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_ROW, XML_ETACTION_PROC_ATTRS,
                OASIS_TABLE_STYLE_REF_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_COLUMN, XML_ETACTION_PROC_ATTRS,
                OASIS_TABLE_STYLE_REF_ACTIONS ),

    // rename office:value-* to *:value-*
    ENTRY1( XML_NAMESPACE_TEXT, XML_VARIABLE_DECL, XML_ETACTION_PROC_ATTRS,
            OASIS_TEXT_VALUE_TYPE_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_VARIABLE_SET, XML_ETACTION_PROC_ATTRS,
            OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_VARIABLE_INPUT, XML_ETACTION_PROC_ATTRS,
            OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_USER_FIELD_DECL, XML_ETACTION_PROC_ATTRS,
            OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_EXPRESSION, XML_ETACTION_PROC_ATTRS,
            OASIS_TEXT_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT, XML_USER_DEFINED, XML_ETACTION_PROC_ATTRS,
            OASIS_DATETIME_ACTIONS ), // Add OASIS_TEXT_VALUE_TYPE_ACTIONS if attrs are added to text:user-defined
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
            OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_COVERED_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
            OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_CHANGE_TRACK_TABLE_CELL, XML_ETACTION_PROC_ATTRS,
            OASIS_TABLE_VALUE_TYPE_ACTIONS), /* generated entry */
//  ENTRY1( XML_NAMESPACE_FORM, XML_PROPERTY, XML_ETACTION_PROC_ATTRS,
//          OASIS_VALUE_TYPE_ACTIONS), /* TODO: generated entry */
//  ENTRY1( XML_NAMESPACE_FORM, XML_LIST_PROPERTY, XML_ETACTION_PROC_ATTRS,
//          OASIS_VALUE_TYPE_ACTIONS), /* generated entry */

    ENTRY1( XML_NAMESPACE_OFFICE, XML_ANNOTATION, XML_ETACTION_MOVE_ELEMS_TO_ATTRS,
            OASIS_ANNOTATION_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_OFFICE, XML_CHANGE_INFO, XML_ETACTION_MOVE_ELEMS_TO_ATTRS,
            OASIS_CHANGE_INFO_ACTIONS ), /* generated entry */

    ENTRY1( XML_NAMESPACE_TEXT, XML_DDE_CONNECTION_DECL, XML_ETACTION_PROC_ATTRS,
                     OASIS_DDE_CONNECTION_DECL_ACTIONS  ),

    ENTRY0( XML_NAMESPACE_FORM, XML_TEXT, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_TEXTAREA, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_FIXED_TEXT, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_FILE, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_PASSWORD, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_FORMATTED_TEXT, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_BUTTON, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_IMAGE, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_CHECKBOX, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_RADIO, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_LISTBOX, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_COMBOBOX, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_FRAME, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_HIDDEN, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_IMAGE_FRAME, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_GRID, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_VALUE_RANGE, XML_ETACTION_FORM_CONTROL ),
    ENTRY0( XML_NAMESPACE_FORM, XML_GENERIC_CONTROL, XML_ETACTION_FORM_CONTROL ),
    ENTRY1( XML_NAMESPACE_FORM, XML_COLUMN, XML_ETACTION_PROC_ATTRS,
                     OASIS_FORM_COLUMN_ACTIONS  ),
    ENTRY1( XML_NAMESPACE_FORM, XML_PROPERTY, XML_ETACTION_FORM_PROPERTY, XML_PROPERTY ),
    ENTRY1( XML_NAMESPACE_FORM, XML_LIST_PROPERTY, XML_ETACTION_FORM_PROPERTY,
                    XML_LIST_PROPERTY ),
    ENTRY1( XML_NAMESPACE_FORM, XML_LIST_VALUE, XML_ETACTION_FORM_PROPERTY, XML_LIST_VALUE ),

    // process xlink:href
    ENTRY1( XML_NAMESPACE_META,  XML_TEMPLATE, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_META,  XML_AUTO_RELOAD, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_SECTION_SOURCE, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_SCRIPT, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TEXT,  XML_ALPHABETICAL_INDEX_AUTO_MARK_FILE, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_TABLE_SOURCE, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_TABLE, XML_CELL_RANGE_SOURCE, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_DRAW,  XML_A, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SOUND, XML_ETACTION_PROC_ATTRS,
        OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY1( XML_NAMESPACE_FORM,  XML_FORM, XML_ETACTION_PROC_ATTRS,
        OASIS_FORM_ACTIONS ), /* generated entry */
//  ENTRY1( XML_NAMESPACE_SVG,   XML_FONT_FACE_URI, XML_ETACTION_PROC_ATTRS,
//      OASIS_XLINK_ACTIONS ), /* generated entry */
//  ENTRY1( XML_NAMESPACE_SVG,   XML_DEFINITION_SRC, XML_ETACTION_PROC_ATTRS,
//      OASIS_XLINK_ACTIONS ), /* generated entry */
    ENTRY2QN( XML_NAMESPACE_CHART, XML_SYMBOL_IMAGE, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
              XML_NAMESPACE_STYLE, XML_SYMBOL_IMAGE,
              OASIS_BACKGROUND_IMAGE_ACTIONS ),
//      OASIS_XLINK_ACTIONS ), /* generated entry */
//  events don't have real URIs
//  ENTRY1( XML_NAMESPACE_PRESENTATION, XML_EVENT_LISTENER, XML_ETACTION_PROC_ATTRS,
//      OASIS_XLINK_ACTIONS ), /* generated entry */
//  ENTRY1( XML_NAMESPACE_SCRIPT, XML_EVENT_LISTENER, XML_ETACTION_PROC_ATTRS,
//      OASIS_XLINK_ACTIONS ), /* generated entry */

    // add namespace prefix to name
    ENTRY1( XML_NAMESPACE_CONFIG, XML_CONFIG_ITEM_SET, XML_ETACTION_PROC_ATTRS,
        OASIS_CONFIG_ITEM_SET_ACTIONS ),

    // add namespace prefix to formula and condition
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_SECTION, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:formula
    ENTRY1( XML_NAMESPACE_TEXT, XML_SEQUENCE, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_DATABASE_NEXT, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY2QN( XML_NAMESPACE_TEXT, XML_DATABASE_ROW_SELECT, XML_ETACTION_RENAME_ELEM_PROC_ATTRS,
        XML_NAMESPACE_TEXT, XML_DATABASE_SELECT,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_CONDITIONAL_TEXT, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_HIDDEN_TEXT, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:condition
    ENTRY1( XML_NAMESPACE_TEXT, XML_HIDDEN_PARAGRAPH, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */
    //  text:formula
    ENTRY1( XML_NAMESPACE_TEXT, XML_TABLE_FORMULA, XML_ETACTION_PROC_ATTRS,
        OASIS_FORMULA_ACTIONS ), /* generated entry */

    //  process table::content-validation
    ENTRY1( XML_NAMESPACE_TABLE, XML_CONTENT_VALIDATION, XML_ETACTION_PROC_ATTRS,
        OASIS_CONTENT_VALIDATION_ACTIONS ),

    // rename <table:dependencies> to <table:dependences>
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_DEPENDENCIES, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_TABLE, XML_DEPENDENCES ),
    ENTRY1Q( XML_NAMESPACE_TABLE, XML_DEPENDENCY, XML_ETACTION_RENAME_ELEM,
                        XML_NAMESPACE_TABLE, XML_DEPENDENCE ),

    // process table::conversion-mode
    ENTRY1( XML_NAMESPACE_TABLE, XML_CONVERSION_MODE, XML_ETACTION_PROC_ATTRS,
            OASIS_DDE_CONV_MODE_ACTIONS ),

    // process table::data-pilot-member
    ENTRY1( XML_NAMESPACE_TABLE, XML_DATA_PILOT_MEMBER, XML_ETACTION_PROC_ATTRS,
            OASIS_DATAPILOT_MEMBER_ACTIONS ),

    // process table::data-pilot-level
    ENTRY1( XML_NAMESPACE_TABLE, XML_DATA_PILOT_LEVEL, XML_ETACTION_PROC_ATTRS,
            OASIS_DATAPILOT_LEVEL_ACTIONS ),

    // process table::source-service
    ENTRY1( XML_NAMESPACE_TABLE, XML_SOURCE_SERVICE, XML_ETACTION_PROC_ATTRS,
            OASIS_SOURCE_SERVICE_ACTIONS ),

    // entries for date time change (#i36576#)
    ENTRY1( XML_NAMESPACE_TEXT, XML_DATE, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_CREATION_DATE, XML_ETACTION_PROC_ATTRS,
                    OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_CREATION_TIME, XML_ETACTION_PROC_ATTRS,
                    OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_PRINT_TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_MODIFICATION_TIME, XML_ETACTION_PROC_ATTRS,
                    OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_EDITING_DURATION, XML_ETACTION_PROC_ATTRS,
                    OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_FORM, XML_TIME, XML_ETACTION_PROC_ATTRS, OASIS_DATETIME_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SETTINGS, XML_ETACTION_PROC_ATTRS,
                    OASIS_DATETIME_ACTIONS ),

    // fix <text:alphabatical-index-mark text:main-etry>
    ENTRY1( XML_NAMESPACE_TEXT, XML_ALPHABETICAL_INDEX_MARK, XML_ETACTION_PROC_ATTRS,
            OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS ),
    ENTRY1( XML_NAMESPACE_TEXT, XML_ALPHABETICAL_INDEX_MARK_START, XML_ETACTION_PROC_ATTRS,
            OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS ),

    // fix id strings in old animation elements
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_DIM, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_PLAY, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SHOW_TEXT, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_SHOW_SHAPE, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_HIDE_TEXT, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),
    ENTRY1( XML_NAMESPACE_PRESENTATION, XML_HIDE_SHAPE, XML_ETACTION_PROC_ATTRS, OASIS_ANIMATION_ACTIONS ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ETACTION_EOT )
};

// XML_ETACTION_STYLE
XMLTransformerActionInit const aStyleActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_FAMILY, XML_ATACTION_STYLE_FAMILY ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_NAME, XML_ATACTION_DECODE_STYLE_NAME,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_DISPLAY_NAME, XML_ATACTION_STYLE_DISPLAY_NAME,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_PARENT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_NEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_LIST_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                 XML_FAMILY_TYPE_LIST ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_MASTER_PAGE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                 XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DEFAULT_OUTLINE_LEVEL, XML_ATACTION_REMOVE ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF,
                 XML_FAMILY_TYPE_TEXT ),    // list level styles
    ENTRY1( XML_NAMESPACE_DRAW,   XML_NAME, XML_ATACTION_DECODE_STYLE_NAME,
                 XML_FAMILY_TYPE_END ),
    ENTRY1( XML_NAMESPACE_DRAW,   XML_DISPLAY_NAME, XML_ATACTION_STYLE_DISPLAY_NAME,
                 XML_FAMILY_TYPE_END ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DISTANCE, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DOTS1_LENGTH, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_DOTS2_LENGTH, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_WIDTH, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_HEIGHT, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_START, XML_ATACTION_NEG_PERCENT ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_END, XML_ATACTION_NEG_PERCENT ),
    ENTRY1( XML_NAMESPACE_XLINK,  XML_HREF, XML_ATACTION_URI_OASIS, sal_uInt32(true) ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FRAME_ELEM_ACTIONS
XMLTransformerActionInit const aFrameActionTable[] =
{
    ENTRY0( XML_NAMESPACE_DRAW,   XML_TEXT_BOX,       XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_IMAGE,          XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_OBJECT,         XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_OBJECT_OLE,     XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_APPLET,         XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_PLUGIN,         XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_DRAW,   XML_FLOATING_FRAME, XML_ETACTION_COPY ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,  XML_ATACTION_EOT )
};

// OASIS_EVENT_ELEM_ACTIONS
XMLTransformerActionInit const aEventActionTable[] =
{
    ENTRY0( XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_HREF ),
    ENTRY1( XML_NAMESPACE_SCRIPT, XML_LANGUAGE,      XML_ATACTION_REMOVE_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_EVENT_NAME,    XML_ATACTION_EVENT_NAME ),
    ENTRY0( XML_NAMESPACE_SCRIPT, XML_MACRO_NAME,    XML_ATACTION_MACRO_NAME ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_EVENT_ELEM_ACTIONS
XMLTransformerActionInit const aDlgActionTable[] =
{
    ENTRY0( XML_NAMESPACE_DLG, XML_BORDER, XML_ATACTION_DLG_BORDER )
};

// action table for OASIS_MASTER_PAGE_ACTIONS
XMLTransformerActionInit const aMasterPageActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_STYLE,  XML_NAME,             XML_ATACTION_DECODE_STYLE_NAME,     XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY1(  XML_NAMESPACE_STYLE,  XML_DISPLAY_NAME,     XML_ATACTION_STYLE_DISPLAY_NAME,    XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY1(  XML_NAMESPACE_STYLE,  XML_NEXT_STYLE_NAME,  XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_PAGE_LAYOUT_NAME, XML_ATACTION_RENAME,                XML_NAMESPACE_STYLE, XML_PAGE_MASTER_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,    XML_ATACTION_EOT )
};

// action table for OASIS_TEXT_STYLE_REF_ACTIONS
XMLTransformerActionInit const aTextStyleRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_TEXT,   XML_STYLE_NAME,         XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_VISITED_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY1( XML_NAMESPACE_XLINK,  XML_HREF,               XML_ATACTION_URI_OASIS,             sal_uInt32(false) ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,      XML_ATACTION_EOT )
};

// action table for OASIS_PARA_STYLE_REF_ACTIONS
XMLTransformerActionInit const aParaStyleRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_TEXT,   XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_LIST_STYLE_REF_ACTIONS
XMLTransformerActionInit const aListStyleRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_TEXT,   XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_LIST ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// action table for OASIS_MASTER_PAGE_REF_ACTIONS
XMLTransformerActionInit const aMasterPageRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_DRAW,   XML_MASTER_PAGE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,    XML_ATACTION_EOT )
};

// action table for OASIS_MAP_STYLE_REF_ACTIONS
XMLTransformerActionInit const aMapStyleRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_STYLE,  XML_APPLY_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_END ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,    XML_ATACTION_EOT )
};

// action table for OASIS_TABLE_STYLE_REF_ACTIONS (#i40011#, #i40015#)
XMLTransformerActionInit const aTableStyleRefActionTable[] =
{
    ENTRY1( XML_NAMESPACE_TABLE,  XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_END ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

XMLTransformerActionInit const aFontFaceActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_SVG,    XML_FONT_FAMILY,     XML_ATACTION_RENAME, XML_NAMESPACE_FO, XML_FONT_FAMILY ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_FONT_ADORNMENTS, XML_ATACTION_RENAME, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// action table for OASIS_PARA_ACTIONS
XMLTransformerActionInit const aParaActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_TEXT,   XML_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY1(  XML_NAMESPACE_TEXT,   XML_COND_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_OUTLINE_LEVEL,   XML_ATACTION_RENAME,                XML_NAMESPACE_TEXT, XML_LEVEL ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,   XML_ATACTION_EOT )
};

// !!ATTENTION!! If you change something here, please also change
// aConnectorActionTable if appropriate
XMLTransformerActionInit const aShapeActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_DRAW,         XML_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_GRAPHIC ),
    ENTRY1(  XML_NAMESPACE_DRAW,         XML_TEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY1(  XML_NAMESPACE_PRESENTATION, XML_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PRESENTATION ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X,               XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y,               XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X1,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y1,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X2,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y2,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_CX,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_CY,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_X,           XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_Y,           XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_R,               XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_RX,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_RY,              XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_WIDTH,           XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_HEIGHT,          XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_WIDTH,       XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_HEIGHT,      XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_WIDTH,       XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_HEIGHT,      XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CORNER_RADIUS,   XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_LINE_SKEW,       XML_ATACTION_INS2INCHS ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CAPTION_POINT_X, XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_CAPTION_POINT_Y, XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DR3D,         XML_DISTANCE,        XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DR3D,         XML_FOCAL_LENGTH,    XML_ATACTION_IN2INCH ),
    ENTRY1Q( XML_NAMESPACE_DRAW,         XML_CONTROL,         XML_ATACTION_RENAME, XML_NAMESPACE_FORM, XML_ID ),
    ENTRY1(  XML_NAMESPACE_XLINK,        XML_HREF,            XML_ATACTION_URI_OASIS, sal_uInt32(true) ),

    // needed by chart:legend.  The legend needs also the draw actions.  As
    // there is no merge mechanism, all actions have to be in the same table
    ENTRY2( XML_NAMESPACE_CHART, XML_LEGEND_POSITION, XML_ATACTION_RENAME_ATTRIBUTE,
            RENAME_ENTRY( XML_START, XML_LEFT ),
            RENAME_ENTRY( XML_END, XML_RIGHT )),

    ENTRY0( XML_NAMESPACE_DRAW, XML_ID, XML_ATACTION_DECODE_ID ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_ANIMATION_ACTIONS
XMLTransformerActionInit const aAnimationActionTable[] =
{
    ENTRY0( XML_NAMESPACE_DRAW,         XML_SHAPE_ID, XML_ATACTION_DECODE_ID ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_DELAY,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_PAUSE,    XML_ATACTION_RNG2ISO_DATETIME ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OOO_CONNECTOR_ACTIONS
XMLTransformerActionInit const aConnectorActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_DRAW,         XML_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_GRAPHIC ),
    ENTRY1(  XML_NAMESPACE_DRAW,         XML_TEXT_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY1(  XML_NAMESPACE_PRESENTATION, XML_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PRESENTATION ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X1,              XML_ATACTION_IN2TWIPS ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y1,              XML_ATACTION_IN2TWIPS ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_X2,              XML_ATACTION_IN2TWIPS ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_Y2,              XML_ATACTION_IN2TWIPS ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_X,           XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_Y,           XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_WIDTH,           XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
    ENTRY0(  XML_NAMESPACE_SVG,          XML_HEIGHT,          XML_ATACTION_SVG_WIDTH_HEIGHT_OASIS ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_WIDTH,       XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MIN_HEIGHT,      XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_WIDTH,       XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_FO,           XML_MAX_HEIGHT,      XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_LINE_SKEW,       XML_ATACTION_INS2INCHS ),
    ENTRY1Q( XML_NAMESPACE_DRAW,         XML_CONTROL,         XML_ATACTION_RENAME, XML_NAMESPACE_FORM, XML_ID ),
    ENTRY1(  XML_NAMESPACE_XLINK,        XML_HREF,            XML_ATACTION_URI_OASIS, sal_uInt32(true) ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_START_SHAPE,     XML_ATACTION_DECODE_ID ),
    ENTRY0(  XML_NAMESPACE_DRAW,         XML_END_SHAPE,       XML_ATACTION_DECODE_ID ),

    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS
XMLTransformerActionInit const aIndexEntryTabStopActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_POSITION,      XML_ATACTION_IN2INCH ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TAB_STOP_ACTIONS
XMLTransformerActionInit const aTabStopActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_POSITION,          XML_ATACTION_IN2INCH ),
    ENTRY1Q( XML_NAMESPACE_STYLE,  XML_LEADER_TEXT,       XML_ATACTION_RENAME, XML_NAMESPACE_STYLE, XML_LEADER_CHAR ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_LEADER_STYLE,      XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_LEADER_TYPE,       XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_LEADER_WIDTH,      XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_LEADER_COLOR,      XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_LEADER_TEXT_STYLE, XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,     XML_ATACTION_EOT )
};

// OASIS_LINENUMBERING_ACTIONS
XMLTransformerActionInit const aLineNumberingActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_OFFSET,              XML_ATACTION_IN2INCH ),
    ENTRY1(  XML_NAMESPACE_TEXT,   XML_STYLE_NAME,          XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_COUNT_IN_TEXT_BOXES, XML_ATACTION_RENAME,                XML_NAMESPACE_TEXT, XML_COUNT_IN_FLOATING_FRAMES ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,       XML_ATACTION_EOT )
};

XMLTransformerActionInit const aFootnoteSepActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_WIDTH,               XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE_BEFORE_SEP, XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE_AFTER_SEP,  XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,       XML_ATACTION_EOT )
};

// OASIS_NOTES_ACTIONS (processed by special context)
XMLTransformerActionInit const aNotesActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TEXT,   XML_NOTE_CLASS,               XML_ATACTION_STYLE_FAMILY ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_CITATION_STYLE_NAME,      XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_CITATION_BODY_STYLE_NAME, XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_DEFAULT_STYLE_NAME,       XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_PARAGRAPH ),
    ENTRY1( XML_NAMESPACE_TEXT,   XML_MASTER_PAGE_NAME,         XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_MASTER_PAGE ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,            XML_ATACTION_EOT )
};

// OASIS_DROP_CAP_ACTIONS
XMLTransformerActionInit const aDropCapActionTable[] =
{
    ENTRY0( XML_NAMESPACE_STYLE,  XML_DISTANCE,      XML_ATACTION_IN2INCH ),
    ENTRY1( XML_NAMESPACE_STYLE,  XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_TEXT ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

XMLTransformerActionInit const aColumnsActionTable[] =
{
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_COLUMN_GAP,    XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_SPACE_BEFORE,  XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_SPACE_AFTER,   XML_ATACTION_REMOVE ),
    ENTRY1Q( XML_NAMESPACE_FO,     XML_START_INDENT,  XML_ATACTION_RENAME_IN2INCH, XML_NAMESPACE_FO, XML_MARGIN_LEFT ),
    ENTRY1Q( XML_NAMESPACE_FO,     XML_END_INDENT,    XML_ATACTION_RENAME_IN2INCH, XML_NAMESPACE_FO, XML_MARGIN_RIGHT ),
    ENTRY0(  XML_NAMESPACE_STYLE,  XML_WIDTH,         XML_ATACTION_IN2INCH ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TEXT_VALUE_TYPE_ACTIONS
XMLTransformerActionInit const aTextValueTypeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_VALUE_TYPE,    XML_ATACTION_RENAME,                  XML_NAMESPACE_TEXT, XML_VALUE_TYPE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_VALUE,         XML_ATACTION_RENAME,                  XML_NAMESPACE_TEXT, XML_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CURRENCY,      XML_ATACTION_RENAME,                  XML_NAMESPACE_TEXT, XML_CURRENCY ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_DATE_VALUE,    XML_ATACTION_RENAME_RNG2ISO_DATETIME, XML_NAMESPACE_TEXT, XML_DATE_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_TIME_VALUE,    XML_ATACTION_RENAME_RNG2ISO_DATETIME, XML_NAMESPACE_TEXT, XML_TIME_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE, XML_ATACTION_RENAME,                  XML_NAMESPACE_TEXT, XML_BOOLEAN_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_STRING_VALUE,  XML_ATACTION_RENAME,                  XML_NAMESPACE_TEXT, XML_STRING_VALUE ),
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_FORMULA,       XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_TABLE_VALUE_TYPE_ACTIONS
XMLTransformerActionInit const aTableValueTypeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_VALUE_TYPE,              XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_VALUE_TYPE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_VALUE,                   XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_CURRENCY,                XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_CURRENCY ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_DATE_VALUE,              XML_ATACTION_RENAME_RNG2ISO_DATETIME, XML_NAMESPACE_TABLE, XML_DATE_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_TIME_VALUE,              XML_ATACTION_RENAME_RNG2ISO_DATETIME, XML_NAMESPACE_TABLE, XML_TIME_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE,           XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_BOOLEAN_VALUE ),
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_STRING_VALUE,            XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_STRING_VALUE ),
    ENTRY1(  XML_NAMESPACE_TABLE,  XML_STYLE_NAME,              XML_ATACTION_DECODE_STYLE_NAME_REF,   XML_FAMILY_TYPE_TABLE_CELL ),
    ENTRY0(  XML_NAMESPACE_TABLE,  XML_FORMULA,                 XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_CONTENT_VALIDATION_NAME, XML_ATACTION_RENAME,                  XML_NAMESPACE_TABLE, XML_VALIDATION_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,           XML_ATACTION_EOT )
};

// action table for OASIS_ANNOTATION_ACTIONS
XMLTransformerActionInit const aAnnotationActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DC,     XML_CREATOR,       XML_ETACTION_MOVE_TO_ATTR,                  XML_NAMESPACE_OFFICE, XML_AUTHOR ),
    ENTRY1Q( XML_NAMESPACE_DC,     XML_DATE,          XML_ETACTION_MOVE_TO_ATTR_RNG2ISO_DATETIME, XML_NAMESPACE_OFFICE, XML_CREATE_DATE ),
    ENTRY1Q( XML_NAMESPACE_META,   XML_DATE_STRING,   XML_ETACTION_MOVE_TO_ATTR,                  XML_NAMESPACE_OFFICE, XML_CREATE_DATE_STRING ),
    ENTRY0(  XML_NAMESPACE_TEXT,   XML_P,             XML_ETACTION_EXTRACT_CHARACTERS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ETACTION_EOT )
};

// action table for OASIS_CHANGE_INFO_ACTIONS
XMLTransformerActionInit const aChangeInfoActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DC,     XML_CREATOR,       XML_ETACTION_MOVE_TO_ATTR,                  XML_NAMESPACE_OFFICE, XML_CHG_AUTHOR ),
    ENTRY1Q( XML_NAMESPACE_DC,     XML_DATE,          XML_ETACTION_MOVE_TO_ATTR_RNG2ISO_DATETIME, XML_NAMESPACE_OFFICE, XML_CHG_DATE_TIME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ETACTION_EOT )
};

// OASIS_BACKGROUND_IMAGE_ACTIONS
XMLTransformerActionInit const aBackgroundImageActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DRAW,   XML_OPACITY,       XML_ATACTION_RENAME_NEG_PERCENT, XML_NAMESPACE_DRAW, XML_TRANSPARENCY ),
    ENTRY1(  XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OASIS,          sal_uInt32(true) ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DDE_CONNECTION_DECL
XMLTransformerActionInit const aDDEConnectionDeclActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_NAME,          XML_ATACTION_RENAME, XML_NAMESPACE_TEXT, XML_NAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORM_CONTROL_ACTIONS
XMLTransformerActionInit const aFormControlActionTable[] =
{
    ENTRY0(   XML_NAMESPACE_FORM,   XML_NAME,                   XML_ATACTION_MOVE_TO_ELEM ),
    ENTRY2QN( XML_NAMESPACE_FORM,   XML_CONTROL_IMPLEMENTATION, XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
                                                                    XML_NAMESPACE_FORM, XML_SERVICE_NAME,  XML_NAMESPACE_OOO ),
    ENTRY0(   XML_NAMESPACE_FORM,   XML_ID,                     XML_ATACTION_MOVE_TO_ELEM ),
    ENTRY1(   XML_NAMESPACE_XLINK,  XML_HREF,                   XML_ATACTION_URI_OASIS, sal_uInt32(false) ),
    ENTRY0(   XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,          XML_ATACTION_EOT )
};

// OASIS_FORM_COLUMN_ACTIONS
XMLTransformerActionInit const aFormColumnActionTable[] =
{
    ENTRY1Q(  XML_NAMESPACE_FORM,   XML_TEXT_STYLE_NAME,        XML_ATACTION_RENAME_DECODE_STYLE_NAME_REF, XML_NAMESPACE_FORM, XML_COLUMN_STYLE_NAME ),
    ENTRY2QN( XML_NAMESPACE_FORM,   XML_CONTROL_IMPLEMENTATION, XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
                                                                    XML_NAMESPACE_FORM, XML_SERVICE_NAME, XML_NAMESPACE_OOO ),
    ENTRY0(   XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,          XML_ATACTION_EOT )
};

// OASIS_FORM_PROP_ACTIONS
XMLTransformerActionInit const aFormPropActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_OFFICE, XML_VALUE_TYPE,    XML_ATACTION_RENAME, XML_NAMESPACE_FORM, XML_PROPERTY_TYPE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_VALUE,         XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_STRING_VALUE,  XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_BOOLEAN_VALUE, XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_DATE_VALUE,    XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TIME_VALUE,    XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_CURRENCY,      XML_ATACTION_REMOVE ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_XLINK_ACTIONS
XMLTransformerActionInit const aXLinkActionTable[] =
{
    ENTRY1( XML_NAMESPACE_XLINK,  XML_HREF,          XML_ATACTION_URI_OASIS, sal_uInt32(false) ),
    ENTRY0( XML_NAMESPACE_TABLE,  XML_REFRESH_DELAY, XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CONFIG_ITEM_SET_ACTIONS
XMLTransformerActionInit const aConfigItemSetActionTable[] =
{
    ENTRY1( XML_NAMESPACE_CONFIG, XML_NAME,          XML_ATACTION_REMOVE_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORMULA_ACTIONS
XMLTransformerActionInit const aFormulaActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TEXT,   XML_CONDITION,     XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( XML_NAMESPACE_TEXT,   XML_FORMULA,       XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( XML_NAMESPACE_TABLE,  XML_CONDITION,     XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( XML_NAMESPACE_TABLE,  XML_FORMULA,       XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CONTENT_VALIDATION_ACTIONS
XMLTransformerActionInit const aContentValidationActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TABLE,  XML_CONDITION,     XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY0( XML_NAMESPACE_TABLE,  XML_DISPLAY_LIST,  XML_ATACTION_REMOVE ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DDE_CONV_MODE_ACTIONS
XMLTransformerActionInit const aDDEConvModeActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_KEEP_TEXT,     XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_LET_TEXT ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATAPILOT_MEMBER_ACTIONS
XMLTransformerActionInit const aDataPilotMemberActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_SHOW_DETAILS,  XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_DISPLAY_DETAILS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATAPILOT_LEVEL_ACTIONS
XMLTransformerActionInit const aDataPilotLevelActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_SHOW_EMPTY,    XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_DISPLAY_EMPTY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_SOURCE_SERVICE_ACTIONS
XMLTransformerActionInit const aSourceServiceActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TABLE,  XML_USER_NAME,     XML_ATACTION_RENAME, XML_NAMESPACE_TABLE, XML_USERNAME ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_CHART_ACTIONS
XMLTransformerActionInit const aChartActionTable[] =
{
    ENTRY0( XML_NAMESPACE_CHART,  XML_CLASS,         XML_ATACTION_REMOVE_ANY_NAMESPACE_PREFIX ),
    ENTRY1( XML_NAMESPACE_DRAW,   XML_STYLE_NAME,    XML_ATACTION_DECODE_STYLE_NAME_REF, XML_FAMILY_TYPE_GRAPHIC ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_WIDTH,         XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_SVG,    XML_HEIGHT,        XML_ATACTION_IN2INCH ),
    ENTRY0( XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_FORM_ACTIONS
XMLTransformerActionInit const aFormActionTable[] =
{
    ENTRY2QN( XML_NAMESPACE_FORM,   XML_CONTROL_IMPLEMENTATION, XML_ATACTION_RENAME_REMOVE_NAMESPACE_PREFIX,
                                                                    XML_NAMESPACE_FORM, XML_SERVICE_NAME, XML_NAMESPACE_OOO ),
    ENTRY1(   XML_NAMESPACE_XLINK,  XML_HREF,                   XML_ATACTION_URI_OASIS, sal_uInt32(false) ),
    ENTRY0(   XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID,          XML_ATACTION_EOT )
};

// OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS
XMLTransformerActionInit const aAlphabeticalIndexMarkActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_TEXT,   XML_MAIN_ENTRY,    XML_ATACTION_RENAME, XML_NAMESPACE_TEXT, XML_MAIN_ETRY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DRAW_AREA_POLYGON_ACTIONS (to be added to OASIS_SHAPE_ACTIONS)
XMLTransformerActionInit const aDrawAreaPolygonActionTable[] =
{
    ENTRY1Q( XML_NAMESPACE_DRAW,   XML_POINTS,        XML_ATACTION_RENAME, XML_NAMESPACE_SVG, XML_POINTS ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_SCRIPT_ACTIONS
XMLTransformerActionInit const aScriptActionTable[] =
{
    ENTRY1(  XML_NAMESPACE_SCRIPT, XML_LANGUAGE,      XML_ATACTION_REMOVE_NAMESPACE_PREFIX, XML_NAMESPACE_OOO ),
    ENTRY1Q( XML_NAMESPACE_OOO,    XML_NAME,          XML_ATACTION_RENAME,                  XML_NAMESPACE_SCRIPT, XML_NAME ),
    ENTRY1Q( XML_NAMESPACE_OOO,    XML_READONLY,      XML_ATACTION_RENAME,                  XML_NAMESPACE_SCRIPT, XML_READONLY ),
    ENTRY0(  XML_NAMESPACE_OFFICE, XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

// OASIS_DATETIME_ACTIONS
XMLTransformerActionInit const aDateTimeActionTable[] =
{
    ENTRY0( XML_NAMESPACE_TEXT,         XML_DATE_VALUE,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_TIME_VALUE,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_DATE_ADJUST,   XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_TIME_ADJUST,   XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TEXT,         XML_DURATION,      XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_DATE_VALUE,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_TIME_VALUE,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_FORM,         XML_VALUE,         XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_FORM,         XML_CURRENT_VALUE, XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TABLE,        XML_DATE_START,    XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TABLE,        XML_DATE_END,      XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_TABLE,        XML_REFRESH_DELAY, XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_DELAY,         XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_PRESENTATION, XML_PAUSE,         XML_ATACTION_RNG2ISO_DATETIME ),
    ENTRY0( XML_NAMESPACE_OFFICE,       XML_TOKEN_INVALID, XML_ATACTION_EOT )
};

XMLTokenEnum const aTokenMap[] =
{
    XML_NONE, XML_SOLID, XML_DOTTED, XML_DASH, XML_LONG_DASH, XML_DOT_DASH,
    XML_DOT_DOT_DASH, XML_WAVE, XML_SMALL_WAVE, XML_TOKEN_END
};

namespace {

class XMLTableTransformerContext_Impl : public XMLTransformerContext
{
    OUString m_aElemQName;

public:
    XMLTableTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;
};

}

XMLTableTransformerContext_Impl::XMLTableTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName ),
    m_aElemQName( rQName )
{
}

void XMLTableTransformerContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    Reference< XAttributeList > xAttrList( rAttrList );

    rtl::Reference<XMLMutableAttributeList> pMutableAttrList;

    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = xAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        if( XML_NAMESPACE_TABLE == nPrefix )
        {
            if ( IsXMLToken( aLocalName, XML_IS_SUB_TABLE ) )
            {
                const OUString& rValue = xAttrList->getValueByIndex( i );
                if( IsXMLToken( rValue, XML_TRUE ) )
                {
                    m_aElemQName = GetTransformer().GetNamespaceMap().GetQNameByKey(
                                XML_NAMESPACE_TABLE,
                                ::xmloff::token::GetXMLToken( XML_SUB_TABLE ) );
                    if ( !pMutableAttrList )
                    {
                        pMutableAttrList =
                            new XMLMutableAttributeList( xAttrList );
                        xAttrList = pMutableAttrList;
                    }
                    pMutableAttrList->RemoveAttributeByIndex( i );
                }
                // #i50521# - no break here for safety reason.
            }
            // Convert attribute table:style-name for <table:table> (#i40011#, #i40015#)
            else if ( IsXMLToken( aLocalName, XML_STYLE_NAME ) )
            {
                const OUString& rValue = xAttrList->getValueByIndex( i );
                OUString aAttrValue( rValue );
                if( XMLTransformerBase::DecodeStyleName(aAttrValue) )
                {
                    if ( !pMutableAttrList )
                    {
                        pMutableAttrList =
                            new XMLMutableAttributeList( xAttrList );
                        xAttrList = pMutableAttrList;
                    }
                    pMutableAttrList->SetValueByIndex( i, aAttrValue );
                }
            }
            else if( IsXMLToken( aLocalName, XML_PRINT ) )
            {
                if ( !pMutableAttrList )
                {
                    pMutableAttrList =
                        new XMLMutableAttributeList( xAttrList );
                    xAttrList = pMutableAttrList;
                }
                pMutableAttrList->RemoveAttributeByIndex( i );
            }
        }
    }

    GetTransformer().GetDocHandler()->startElement( m_aElemQName, xAttrList );
}

void XMLTableTransformerContext_Impl::EndElement()
{
    GetTransformer().GetDocHandler()->endElement( m_aElemQName );
}

namespace {

class XMLBodyOASISTransformerContext_Impl : public XMLTransformerContext
{
    bool m_bFirstChild;

public:
    XMLBodyOASISTransformerContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;

    virtual rtl::Reference<XMLTransformerContext> CreateChildContext( sal_uInt16 nPrefix,
                                   const OUString& rLocalName,
                                   const OUString& rQName,
                                   const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;
};

}

XMLBodyOASISTransformerContext_Impl::XMLBodyOASISTransformerContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName ),
    m_bFirstChild( false )
{
}

void XMLBodyOASISTransformerContext_Impl::StartElement(
        const Reference< XAttributeList >& )
{
}

rtl::Reference<XMLTransformerContext> XMLBodyOASISTransformerContext_Impl::CreateChildContext( sal_uInt16 nPrefix,
                                   const OUString& rLocalName,
                                   const OUString& rQName,
                                   const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList )
{
    if (!m_bFirstChild)
    {
        m_bFirstChild = true;
        XMLTransformerContext::StartElement(xAttrList);
    }

    return XMLTransformerContext::CreateChildContext(nPrefix, rLocalName, rQName, xAttrList);
}

void XMLBodyOASISTransformerContext_Impl::EndElement()
{
    if (!m_bFirstChild)
        XMLTransformerContext::StartElement(Reference< XAttributeList >());

    XMLTransformerContext::EndElement();
}

namespace {

class XMLTabStopOASISTContext_Impl : public XMLPersElemContentTContext
{
public:
    XMLTabStopOASISTContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
};

}

XMLTabStopOASISTContext_Impl::XMLTabStopOASISTContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLPersElemContentTContext( rImp, rQName )
{
}

void XMLTabStopOASISTContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    XMLTransformerActions *pActions =
        GetTransformer().GetUserDefinedActions( OASIS_TAB_STOP_ACTIONS  );
    SAL_WARN_IF( nullptr == pActions, "xmloff.transform", "got no actions" );

    sal_Unicode cStyleLeaderChar = 0;
    sal_Int16 nLeaderText = -1;
    Reference< XAttributeList > xAttrList( rAttrList );
    rtl::Reference<XMLMutableAttributeList> pMutableAttrList;
    sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = xAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        XMLTransformerActions::key_type aKey( nPrefix, aLocalName );
        XMLTransformerActions::const_iterator aIter =
            pActions->find( aKey );
        if( aIter != pActions->end() )
        {
            if( !pMutableAttrList )
            {
                pMutableAttrList =
                    new XMLMutableAttributeList( xAttrList );
                xAttrList = pMutableAttrList;
            }
            const OUString& rAttrValue = xAttrList->getValueByIndex( i );
            switch( (*aIter).second.m_nActionType )
            {
            case XML_ATACTION_REMOVE:
                if( IsXMLToken( aLocalName, XML_LEADER_STYLE ) )
                {
                    if( IsXMLToken( rAttrValue, XML_NONE ) )
                        cStyleLeaderChar = ' ';
                    else if( IsXMLToken( rAttrValue, XML_DOTTED ) )
                        cStyleLeaderChar = '.';
                    else
                        cStyleLeaderChar = 0;
                    pMutableAttrList->RemoveAttributeByIndex( i );
                    --i;
                    --nAttrCount;
                }
                break;
            case XML_ATACTION_RENAME:
                {
                    OUString aNewAttrQName(
                        GetTransformer().GetNamespaceMap().GetQNameByKey(
                            (*aIter).second.GetQNamePrefixFromParam1(),
                            ::xmloff::token::GetXMLToken(
                            (*aIter).second.GetQNameTokenFromParam1()) ) );
                    pMutableAttrList->RenameAttributeByIndex( i,
                                                              aNewAttrQName );
                }
                if( IsXMLToken( aLocalName, XML_LEADER_TEXT ) )
                {
                    if( rAttrValue.getLength() > 1 )
                    {
                        OUString aAttrValue( rAttrValue.copy( 0, 1 ) );
                        pMutableAttrList->SetValueByIndex( i, aAttrValue );
                        nLeaderText = i;
                    }
                }
                break;
            case XML_ATACTION_IN2INCH:
                {
                    OUString aAttrValue( rAttrValue );
                    if( XMLTransformerBase::ReplaceSingleInWithInch(
                                aAttrValue ) )
                        pMutableAttrList->SetValueByIndex( i, aAttrValue );
                }
                break;
            default:
                SAL_WARN( "xmloff.transform", "unknown action" );
                break;
            }
        }
    }

    if( cStyleLeaderChar && ' ' != cStyleLeaderChar )
    {
        if( nLeaderText != -1 )
        {
            OUString aNewAttrQName(
                GetTransformer().GetNamespaceMap().GetQNameByKey(
                            XML_NAMESPACE_STYLE,
                            ::xmloff::token::GetXMLToken( XML_LEADER_CHAR ) ) );
            pMutableAttrList->AddAttribute( aNewAttrQName,
                                    OUString( cStyleLeaderChar ) );
        }
    }
    else
    {
        if( nLeaderText != -1 )
            pMutableAttrList->RemoveAttributeByIndex( nLeaderText );
    }

    XMLPersElemContentTContext::StartElement( xAttrList );
}

namespace {

class XMLConfigItemTContext_Impl : public XMLTransformerContext
{
    OUString m_aContent;
    bool m_bIsRedlineProtectionKey;
    bool m_bIsCursorX;
    bool m_bIsCursorY;

public:
    XMLConfigItemTContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
    virtual void EndElement() override;

    virtual void Characters( const OUString& rChars ) override;
};

}

XMLConfigItemTContext_Impl::XMLConfigItemTContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName ) :
    XMLTransformerContext( rImp, rQName ),
    m_bIsRedlineProtectionKey( false ),
    m_bIsCursorX( false ),
    m_bIsCursorY( false )
{
}

void XMLConfigItemTContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    sal_Int16 nAttrCount = rAttrList.is() ? rAttrList->getLength() : 0;
    for( sal_Int16 i=0; i < nAttrCount; i++ )
    {
        const OUString& rAttrName = rAttrList->getNameByIndex( i );
        OUString aLocalName;
        sal_uInt16 nPrefix =
            GetTransformer().GetNamespaceMap().GetKeyByAttrName( rAttrName,
                                                                 &aLocalName );
        if( XML_NAMESPACE_CONFIG == nPrefix )
        {
            if ( IsXMLToken( aLocalName, XML_NAME ) )
            {
                const OUString& rValue = rAttrList->getValueByIndex( i );
                if( rValue == "RedlineProtectionKey" )
                    m_bIsRedlineProtectionKey = true;
                else if( rValue == "CursorPositionX" )
                    m_bIsCursorX = true;
                else if( rValue == "CursorPositionY" )
                    m_bIsCursorY = true;

                break;
            }
        }
    }

    XMLTransformerContext::StartElement( rAttrList );
}

void XMLConfigItemTContext_Impl::Characters( const OUString& rChars )
{
    OUString sChars(rChars);
    if (m_bIsRedlineProtectionKey)
        m_aContent += rChars;
    else if (m_bIsCursorX || m_bIsCursorY)
    {
        sal_Int32 nPos = rChars.toInt32();
        if (m_bIsCursorX && nPos > 255)
            nPos = 255;
        else if (m_bIsCursorY && nPos > 31999)
            nPos = 31999;

        sChars = OUString::number(nPos);
    }

    XMLTransformerContext::Characters( sChars );
}

void XMLConfigItemTContext_Impl::EndElement()
{

    if( m_bIsRedlineProtectionKey )
    {
        const Reference< XPropertySet > rPropSet =
            GetTransformer().GetPropertySet();
        if( rPropSet.is() )
        {
            OUString aPropName(u"RedlineProtectionKey"_ustr);
            Reference< XPropertySetInfo > xPropSetInfo(
                        rPropSet->getPropertySetInfo() );
            if( xPropSetInfo.is() &&
                xPropSetInfo->hasPropertyByName( aPropName ) )
            {
                Sequence < sal_Int8 > aKey;
                ::comphelper::Base64::decode( aKey, m_aContent );
                rPropSet->setPropertyValue( aPropName, Any( aKey ) );
            }
        }
    }
    XMLTransformerContext::EndElement();
}

namespace {

class XMLTrackedChangesOASISTContext_Impl : public XMLTransformerContext
{
    OUString const m_aAttrQName;

public:

    XMLTrackedChangesOASISTContext_Impl( XMLTransformerBase& rTransformer,
                           const OUString& rQName,
                               sal_uInt16 nPrefix,
                            XMLTokenEnum eToken );

    virtual void StartElement( const css::uno::Reference< css::xml::sax::XAttributeList >& xAttrList ) override;
};

}

XMLTrackedChangesOASISTContext_Impl::XMLTrackedChangesOASISTContext_Impl(
        XMLTransformerBase& rImp,
        const OUString& rQName,
        sal_uInt16 nPrefix,
        XMLTokenEnum eToken ) :
    XMLTransformerContext( rImp, rQName ),
    m_aAttrQName( rImp.GetNamespaceMap().GetQNameByKey( nPrefix,
                                                        GetXMLToken(eToken)) )
{
}

void XMLTrackedChangesOASISTContext_Impl::StartElement(
        const Reference< XAttributeList >& rAttrList )
{
    Reference< XAttributeList > xAttrList( rAttrList );
    const Reference< XPropertySet > rPropSet =
        GetTransformer().GetPropertySet();
    if( rPropSet.is() )
    {
        OUString aPropName(u"RedlineProtectionKey"_ustr);
        Reference< XPropertySetInfo > xPropSetInfo(
                    rPropSet->getPropertySetInfo() );
        if( xPropSetInfo.is() &&
            xPropSetInfo->hasPropertyByName( aPropName ) )
        {
            Any aAny = rPropSet->getPropertyValue( aPropName);
            Sequence < sal_Int8 > aKey;
            aAny >>= aKey;
            if( aKey.hasElements() )
            {
                OUStringBuffer aBuffer;
                ::comphelper::Base64::encode( aBuffer, aKey );
                rtl::Reference<XMLMutableAttributeList> pMutableAttrList =
                    new XMLMutableAttributeList( xAttrList );
                xAttrList = pMutableAttrList;
                pMutableAttrList->AddAttribute( m_aAttrQName,
                                                aBuffer.makeStringAndClear() );
            }
        }
    }
    XMLTransformerContext::StartElement( xAttrList );
}

XMLTransformerContext *Oasis2OOoTransformer::CreateUserDefinedContext(
                              const TransformerAction_Impl& rAction,
                              const OUString& rQName,
                                 bool bPersistent )
{
    switch( rAction.m_nActionType )
    {
    case XML_ETACTION_META:
        return new XMLMetaTransformerContext( *this, rQName );
    case XML_ETACTION_DOCUMENT:
        return new XMLDocumentTransformerContext( *this, rQName );
    case XML_ETACTION_BODY:
        return new XMLBodyOASISTransformerContext_Impl( *this, rQName );
    case XML_ETACTION_NOTES:
        return new XMLNotesTransformerContext( *this, rQName,
                static_cast< XMLTokenEnum>( rAction.m_nParam1 ), bPersistent );
    case XML_ETACTION_TABLE:
        return new XMLTableTransformerContext_Impl( *this, rQName );
    case XML_ETACTION_STYLE:
        return new XMLStyleOASISTContext( *this, rQName, bPersistent );
    case XML_ETACTION_STYLE_RENAME:
        return new XMLStyleOASISTContext( *this, rQName,
                    rAction.GetQNamePrefixFromParam1(),
                    rAction.GetQNameTokenFromParam1(), bPersistent );
    case XML_ETACTION_FRAME:
        return new XMLFrameOASISTransformerContext( *this, rQName );
    case XML_ETACTION_EVENT:
        return new XMLEventOASISTransformerContext( *this, rQName );
    case XML_ETACTION_DLG:
        return new XMLDlgOASISTransformerContext( *this, rQName );
    case XML_ETACTION_TAB_STOP:
        return new XMLTabStopOASISTContext_Impl( *this, rQName );
    case XML_ETACTION_FORM_CONTROL:
        {
            const XMLTransformerContext *pCurrent = GetCurrentContext();
            return new XMLControlOASISTransformerContext( *this, rQName,
                        pCurrent && pCurrent->HasQName( XML_NAMESPACE_FORM,
                                           XML_FORM ) );
        }
    case XML_ETACTION_FORM_PROPERTY:
        return new XMLFormPropOASISTransformerContext( *this, rQName,
                static_cast< XMLTokenEnum >( rAction.m_nParam1 ) );
    case XML_ETACTION_CHART:
        return new XMLChartOASISTransformerContext( *this, rQName );
    case XML_ETACTION_CONFIG_ITEM:
        return new XMLConfigItemTContext_Impl( *this, rQName );
    case XML_ETACTION_TRACKED_CHANGES:
        return new XMLTrackedChangesOASISTContext_Impl( *this, rQName,
                               rAction.GetQNamePrefixFromParam1(),
                            rAction.GetQNameTokenFromParam1() );
    case XML_ETACTION_CHART_PLOT_AREA:
        return new XMLChartPlotAreaOASISTContext( *this, rQName );
    default:
        SAL_WARN( "xmloff.transform", "no user defined context found!" );
        break;
    }

    // default is copying
    return new XMLTransformerContext( *this, rQName );
}

XMLTransformerActions *Oasis2OOoTransformer::GetUserDefinedActions(
        sal_uInt16 n )
{
    XMLTransformerActions *pActions = nullptr;
    if( n < MAX_OASIS_ACTIONS )
    {
        if( !m_aActions[n] )
        {
            if( n<MAX_OASIS_PROP_ACTIONS )
            {
                m_aActions[n].reset(
                    XMLStyleOASISTContext::CreateTransformerActions( n ) );
            }
            else switch( n )
            {
            case OASIS_STYLE_ACTIONS:
                m_aActions[OASIS_STYLE_ACTIONS].reset(
                    new XMLTransformerActions( aStyleActionTable ) );
                break;
            case OASIS_FONT_FACE_ACTIONS:
                m_aActions[OASIS_FONT_FACE_ACTIONS].reset(
                    new XMLTransformerActions( aFontFaceActionTable ) );
                break;
            case OASIS_SHAPE_ACTIONS:
                m_aActions[OASIS_SHAPE_ACTIONS].reset(
                    new XMLTransformerActions( aShapeActionTable ) );
                break;
            case OASIS_CONNECTOR_ACTIONS:
                m_aActions[OASIS_CONNECTOR_ACTIONS].reset(
                    new XMLTransformerActions( aConnectorActionTable ) );
                break;
            case OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS:
                m_aActions[OASIS_INDEX_ENTRY_TAB_STOP_ACTIONS].reset(
                    new XMLTransformerActions( aIndexEntryTabStopActionTable ) );
                break;
            case OASIS_TAB_STOP_ACTIONS:
                m_aActions[OASIS_TAB_STOP_ACTIONS].reset(
                    new XMLTransformerActions( aTabStopActionTable ) );
                break;
            case OASIS_LINENUMBERING_ACTIONS:
                m_aActions[OASIS_LINENUMBERING_ACTIONS].reset(
                    new XMLTransformerActions( aLineNumberingActionTable ) );
                break;
            case OASIS_FOOTNOTE_SEP_ACTIONS:
                m_aActions[OASIS_FOOTNOTE_SEP_ACTIONS].reset(
                    new XMLTransformerActions( aFootnoteSepActionTable ) );
                break;
            case OASIS_DROP_CAP_ACTIONS:
                m_aActions[OASIS_DROP_CAP_ACTIONS].reset(
                    new XMLTransformerActions( aDropCapActionTable ) );
                break;
            case OASIS_COLUMNS_ACTIONS:
                m_aActions[OASIS_COLUMNS_ACTIONS].reset(
                    new XMLTransformerActions( aColumnsActionTable ) );
                break;
            case OASIS_TEXT_VALUE_TYPE_ACTIONS:
                m_aActions[OASIS_TEXT_VALUE_TYPE_ACTIONS].reset(
                    new XMLTransformerActions( aTextValueTypeActionTable ) );
                break;
            case OASIS_TABLE_VALUE_TYPE_ACTIONS:
                m_aActions[OASIS_TABLE_VALUE_TYPE_ACTIONS].reset(
                    new XMLTransformerActions( aTableValueTypeActionTable ) );
                break;
            case OASIS_PARA_ACTIONS:
                m_aActions[OASIS_PARA_ACTIONS].reset(
                    new XMLTransformerActions( aParaActionTable ) );
                break;
            case OASIS_LIST_STYLE_REF_ACTIONS:
                m_aActions[OASIS_LIST_STYLE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aListStyleRefActionTable ) );
                break;
            case OASIS_TEXT_STYLE_REF_ACTIONS:
                m_aActions[OASIS_TEXT_STYLE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aTextStyleRefActionTable ) );
                break;
            case OASIS_PARA_STYLE_REF_ACTIONS:
                m_aActions[OASIS_PARA_STYLE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aParaStyleRefActionTable ) );
                break;
            case OASIS_MASTER_PAGE_REF_ACTIONS:
                m_aActions[OASIS_MASTER_PAGE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aMasterPageRefActionTable ) );
                break;
            case OASIS_MAP_STYLE_REF_ACTIONS:
                m_aActions[OASIS_MAP_STYLE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aMapStyleRefActionTable ) );
                break;
            case OASIS_MASTER_PAGE_ACTIONS:
                m_aActions[OASIS_MASTER_PAGE_ACTIONS].reset(
                    new XMLTransformerActions( aMasterPageActionTable ) );
                break;
            case OASIS_NOTES_ACTIONS:
                m_aActions[OASIS_NOTES_ACTIONS].reset(
                    new XMLTransformerActions( aNotesActionTable ) );
                break;
            case OASIS_ANNOTATION_ACTIONS:
                m_aActions[OASIS_ANNOTATION_ACTIONS].reset(
                    new XMLTransformerActions( aAnnotationActionTable ) );
                break;
            case OASIS_CHANGE_INFO_ACTIONS:
                m_aActions[OASIS_CHANGE_INFO_ACTIONS].reset(
                    new XMLTransformerActions( aChangeInfoActionTable ) );
                break;
            case OASIS_FRAME_ELEM_ACTIONS:
                m_aActions[OASIS_FRAME_ELEM_ACTIONS].reset(
                    new XMLTransformerActions( aFrameActionTable ) );
                break;
            case OASIS_BACKGROUND_IMAGE_ACTIONS:
                m_aActions[OASIS_BACKGROUND_IMAGE_ACTIONS].reset(
                    new XMLTransformerActions( aBackgroundImageActionTable ) );
                break;
            case OASIS_DDE_CONNECTION_DECL_ACTIONS:
                m_aActions[OASIS_DDE_CONNECTION_DECL_ACTIONS].reset(
                    new XMLTransformerActions( aDDEConnectionDeclActionTable ) );
                break;
            case OASIS_EVENT_ACTIONS:
                m_aActions[OASIS_EVENT_ACTIONS].reset(
                    new XMLTransformerActions( aEventActionTable ) );
                break;
            case OASIS_DLG_ACTIONS:
                m_aActions[OASIS_DLG_ACTIONS].reset(
                    new XMLTransformerActions( aDlgActionTable ) );
                break;
            case OASIS_FORM_CONTROL_ACTIONS:
                m_aActions[OASIS_FORM_CONTROL_ACTIONS].reset(
                    new XMLTransformerActions( aFormControlActionTable ) );
                break;
            case OASIS_FORM_COLUMN_ACTIONS:
                m_aActions[OASIS_FORM_COLUMN_ACTIONS].reset(
                    new XMLTransformerActions( aFormColumnActionTable ) );
                break;
            case OASIS_FORM_PROP_ACTIONS:
                m_aActions[OASIS_FORM_PROP_ACTIONS].reset(
                    new XMLTransformerActions( aFormPropActionTable ) );
                break;
            case OASIS_XLINK_ACTIONS:
                m_aActions[OASIS_XLINK_ACTIONS].reset(
                    new XMLTransformerActions( aXLinkActionTable ) );
                break;
            case OASIS_CONFIG_ITEM_SET_ACTIONS:
                m_aActions[OASIS_CONFIG_ITEM_SET_ACTIONS].reset(
                    new XMLTransformerActions( aConfigItemSetActionTable ) );
                break;
            case OASIS_FORMULA_ACTIONS:
                m_aActions[OASIS_FORMULA_ACTIONS].reset(
                    new XMLTransformerActions( aFormulaActionTable ) );
                break;
            case OASIS_CHART_ACTIONS:
                m_aActions[OASIS_CHART_ACTIONS].reset(
                    new XMLTransformerActions( aChartActionTable ) );
                break;
            case OASIS_FORM_ACTIONS:
                m_aActions[OASIS_FORM_ACTIONS].reset(
                    new XMLTransformerActions( aFormActionTable ) );
                break;
            case OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS:
                m_aActions[OASIS_ALPHABETICAL_INDEX_MARK_ACTIONS].reset(
                    new XMLTransformerActions(
                        aAlphabeticalIndexMarkActionTable ) );
                break;
            case OASIS_CONTENT_VALIDATION_ACTIONS:
                m_aActions[OASIS_CONTENT_VALIDATION_ACTIONS].reset(
                    new XMLTransformerActions( aContentValidationActionTable ) );
                break;
            case OASIS_DDE_CONV_MODE_ACTIONS:
                m_aActions[OASIS_DDE_CONV_MODE_ACTIONS].reset(
                    new XMLTransformerActions( aDDEConvModeActionTable ) );
                break;
            case OASIS_DATAPILOT_MEMBER_ACTIONS:
                m_aActions[OASIS_DATAPILOT_MEMBER_ACTIONS].reset(
                    new XMLTransformerActions( aDataPilotMemberActionTable ) );
                break;
            case OASIS_DATAPILOT_LEVEL_ACTIONS:
                m_aActions[OASIS_DATAPILOT_LEVEL_ACTIONS].reset(
                    new XMLTransformerActions( aDataPilotLevelActionTable ) );
                break;
            case OASIS_SOURCE_SERVICE_ACTIONS:
                m_aActions[OASIS_SOURCE_SERVICE_ACTIONS].reset(
                    new XMLTransformerActions( aSourceServiceActionTable ) );
                break;
            case OASIS_DRAW_AREA_POLYGON_ACTIONS:
                m_aActions[OASIS_DRAW_AREA_POLYGON_ACTIONS].reset(
                    new XMLTransformerActions( aShapeActionTable ) );
                m_aActions[OASIS_DRAW_AREA_POLYGON_ACTIONS]
                    ->Add( aDrawAreaPolygonActionTable );
                break;
            case OASIS_SCRIPT_ACTIONS:
                m_aActions[OASIS_SCRIPT_ACTIONS].reset(
                    new XMLTransformerActions( aScriptActionTable ) );
                break;
            case OASIS_DATETIME_ACTIONS:
                m_aActions[OASIS_DATETIME_ACTIONS].reset(
                    new XMLTransformerActions( aDateTimeActionTable ) );
                break;
            // Bugdoc with table won't load correctly (#i40011#, #i40015#)
            case OASIS_TABLE_STYLE_REF_ACTIONS:
                m_aActions[OASIS_TABLE_STYLE_REF_ACTIONS].reset(
                    new XMLTransformerActions( aTableStyleRefActionTable ) );
                break;
            case OASIS_ANIMATION_ACTIONS:
                m_aActions[OASIS_ANIMATION_ACTIONS].reset(
                    new XMLTransformerActions( aAnimationActionTable ) );
                break;
            }
        }
        pActions = m_aActions[n].get();
    }

    return pActions;
}

OUString Oasis2OOoTransformer::GetEventName( const OUString& rName,
                                             bool bForm )
{
    if( bForm && !m_pFormEventMap )
        m_pFormEventMap =
            XMLEventOASISTransformerContext::CreateFormEventMap();
    if( !m_pEventMap )
        m_pEventMap = XMLEventOASISTransformerContext::CreateEventMap();

    OUString aMacroName;
    sal_uInt16 nPrefix =
        GetNamespaceMap().GetKeyByAttrName( rName, &aMacroName );
    return XMLEventOASISTransformerContext::GetEventName(
                nPrefix, aMacroName, *m_pEventMap,
                   bForm ? m_pFormEventMap : nullptr  );
}

Oasis2OOoTransformer::Oasis2OOoTransformer() noexcept :
    XMLTransformerBase( aActionTable, aTokenMap ),
    m_pEventMap( nullptr ),
    m_pFormEventMap( nullptr )
{
    GetNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE), XML_NAMESPACE_OFFICE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_OFFICE), GetXMLToken(XML_N_OFFICE_OOO), XML_NAMESPACE_OFFICE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META), XML_NAMESPACE_META );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_META), GetXMLToken(XML_N_META_OOO), XML_NAMESPACE_META );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE), XML_NAMESPACE_STYLE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_STYLE), GetXMLToken(XML_N_STYLE_OOO), XML_NAMESPACE_STYLE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER), XML_NAMESPACE_NUMBER );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_NUMBER), GetXMLToken(XML_N_NUMBER_OOO), XML_NAMESPACE_NUMBER );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG), XML_NAMESPACE_CONFIG );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CONFIG), GetXMLToken(XML_N_CONFIG_OOO), XML_NAMESPACE_CONFIG );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT), XML_NAMESPACE_TEXT );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TEXT), GetXMLToken(XML_N_TEXT_OOO), XML_NAMESPACE_TEXT );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE), XML_NAMESPACE_TABLE );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_TABLE), GetXMLToken(XML_N_TABLE_OOO), XML_NAMESPACE_TABLE );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW), XML_NAMESPACE_DRAW );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DRAW), GetXMLToken(XML_N_DRAW_OOO), XML_NAMESPACE_DRAW );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D), XML_NAMESPACE_DR3D );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DR3D), GetXMLToken(XML_N_DR3D_OOO), XML_NAMESPACE_DR3D );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION), XML_NAMESPACE_PRESENTATION );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_PRESENTATION), GetXMLToken(XML_N_PRESENTATION_OOO), XML_NAMESPACE_PRESENTATION );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART), XML_NAMESPACE_CHART );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_CHART), GetXMLToken(XML_N_CHART_OOO), XML_NAMESPACE_CHART );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM), XML_NAMESPACE_FORM );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FORM), GetXMLToken(XML_N_FORM_OOO), XML_NAMESPACE_FORM );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT), XML_NAMESPACE_SCRIPT );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SCRIPT), GetXMLToken(XML_N_SCRIPT_OOO), XML_NAMESPACE_SCRIPT );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_DLG), GetXMLToken(XML_N_DLG), XML_NAMESPACE_DLG );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_DLG), GetXMLToken(XML_N_DLG), XML_NAMESPACE_DLG );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO_COMPAT), XML_NAMESPACE_FO );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_FO), GetXMLToken(XML_N_FO), XML_NAMESPACE_FO );

    GetNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG_COMPAT), XML_NAMESPACE_SVG );
    GetReplaceNamespaceMap().Add( GetXMLToken(XML_NP_SVG), GetXMLToken(XML_N_SVG),  XML_NAMESPACE_SVG );

    for(auto & rp : m_aActions)
        rp.reset();
}

Oasis2OOoTransformer::~Oasis2OOoTransformer() noexcept
{
    for(auto & rp : m_aActions)
        rp.reset();
    XMLEventOASISTransformerContext::FlushEventMap( m_pEventMap );
    XMLEventOASISTransformerContext::FlushEventMap( m_pFormEventMap );
}

// XServiceInfo
OUString SAL_CALL Oasis2OOoTransformer::getImplementationName()
{
    return u"com.sun.star.comp.Oasis2OOoTransformer"_ustr;
}

sal_Bool SAL_CALL Oasis2OOoTransformer::supportsService( const OUString& ServiceName )
{
    return cppu::supportsService(this, ServiceName);
}

Sequence< OUString > SAL_CALL Oasis2OOoTransformer::getSupportedServiceNames(  )
{
    return { };
}

// Service registration

extern "C" SAL_DLLPUBLIC_EXPORT css::uno::XInterface*
xmloff_Oasis2OOoTransformer_get_implementation(
    css::uno::XComponentContext* , css::uno::Sequence<css::uno::Any> const&)
{
    SAL_INFO("xmloff.transform", "Creating Oasis2OOoTransformer");
    return cppu::acquire(new Oasis2OOoTransformer);
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
